/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.war.action.WebflowReportContext;
import com.jaspersoft.jasperserver.war.util.SessionObjectSerieAccessor;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.RequestContext;

public class WebflowReportContextAccessor {
    private static final Log log = LogFactory.getLog(WebflowReportContextAccessor.class);
    private String parameterFlowReportContext = "rptCtx";
    private String requestParameterReportContextId = "jr_ctxid";
    private SessionObjectSerieAccessor sessionAccessor;

    public void initFlowScope(RequestContext requestContext) {
        HashMap flowValues = new HashMap();
        requestContext.getRequestParameters().asMap();
        flowValues.putAll(requestContext.getRequestParameters().asMap());
        Map oldFlowMap = (Map)requestContext.getFlowScope().get(this.parameterFlowReportContext);
        if (oldFlowMap != null) {
            flowValues.put(this.requestParameterReportContextId, oldFlowMap.get(this.requestParameterReportContextId));
        }
        requestContext.getFlowScope().put(this.parameterFlowReportContext, flowValues);
    }

    public WebflowReportContext getContext(RequestContext requestContext) {
        return this.getContext(requestContext, true);
    }

    public WebflowReportContext getContext(RequestContext requestContext, boolean create) {
        ExternalContext ec = requestContext.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)ec.getNativeRequest();
        WebflowReportContext webflowReportContext = null;
        Map flowMap = (Map)requestContext.getFlowScope().get(this.parameterFlowReportContext);
        String reportContextId = null;
        if (flowMap != null) {
            reportContextId = (String)flowMap.get(this.requestParameterReportContextId);
        }
        if (reportContextId != null) {
            webflowReportContext = (WebflowReportContext)this.sessionAccessor.getObject(request, reportContextId);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("flow found " + webflowReportContext + " for id " + reportContextId));
        }
        if (webflowReportContext == null) {
            webflowReportContext = new WebflowReportContext();
            String sessionId = this.sessionAccessor.putObject(request, webflowReportContext);
            webflowReportContext.setId(sessionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("flow created " + webflowReportContext + " with id " + sessionId));
            }
            if (flowMap != null) {
                flowMap.put(this.requestParameterReportContextId, webflowReportContext.getId());
                requestContext.getFlowScope().put(this.parameterFlowReportContext, (Object)flowMap);
            }
        }
        if (webflowReportContext != null) {
            webflowReportContext.setRequestContext(requestContext);
            webflowReportContext.setFlowValues(flowMap);
            webflowReportContext.setParameterValue("REPORT_CONTEXT", webflowReportContext);
        }
        return webflowReportContext;
    }

    public WebflowReportContext getContextById(HttpServletRequest request, String reportContextId) {
        return (WebflowReportContext)this.sessionAccessor.getObject(request, reportContextId);
    }

    public WebflowReportContext getContext(HttpServletRequest request, Map flowMap) {
        WebflowReportContext webflowReportContext = null;
        String reportContextId = null;
        if (flowMap != null) {
            reportContextId = (String)flowMap.get(this.requestParameterReportContextId);
        }
        if (reportContextId != null) {
            webflowReportContext = (WebflowReportContext)this.sessionAccessor.getObject(request, reportContextId);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("request found " + webflowReportContext + " for id " + reportContextId));
        }
        if (webflowReportContext == null) {
            webflowReportContext = new WebflowReportContext();
            webflowReportContext.setFlowValues(flowMap);
            webflowReportContext.setParameterValue("REPORT_CONTEXT", webflowReportContext);
            String sessionId = this.sessionAccessor.putObject(request, webflowReportContext);
            webflowReportContext.setId(sessionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("request created " + webflowReportContext + " with id " + sessionId));
            }
        }
        return webflowReportContext;
    }

    public void removeContext(RequestContext requestContext) {
        ExternalContext ec = requestContext.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)ec.getNativeRequest();
        Map flowMap = (Map)requestContext.getFlowScope().get(this.parameterFlowReportContext);
        String reportContextId = null;
        if (flowMap != null) {
            reportContextId = (String)flowMap.get(this.requestParameterReportContextId);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("found report context id " + reportContextId + " for removal"));
        }
        if (reportContextId != null) {
            this.getSessionAccessor().removeObject(request, reportContextId);
        }
    }

    public SessionObjectSerieAccessor getSessionAccessor() {
        return this.sessionAccessor;
    }

    public void setSessionAccessor(SessionObjectSerieAccessor sessionAccessor) {
        this.sessionAccessor = sessionAccessor;
    }

    public String getParameterFlowReportContext() {
        return this.parameterFlowReportContext;
    }

    public void setParameterFlowReportContext(String parameterFlowReportContext) {
        this.parameterFlowReportContext = parameterFlowReportContext;
    }

    public String getRequestParameterReportContextId() {
        return this.requestParameterReportContextId;
    }

    public void setRequestParameterReportContextId(String requestParameterReportContextId) {
        this.requestParameterReportContextId = requestParameterReportContextId;
    }
}

