/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade;

import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorsImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControlsContainer;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.InputControlState;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.ReportInputControl;
import com.jaspersoft.jasperserver.war.cascade.CachedRepositoryService;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.ControlLogic;
import com.jaspersoft.jasperserver.war.cascade.EvaluationEventsHandler;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationError;
import com.jaspersoft.jasperserver.war.cascade.InputControlsLogicService;
import com.jaspersoft.jasperserver.war.cascade.InputControlsValidationException;
import com.jaspersoft.jasperserver.war.cascade.cache.ControlLogicCacheManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="inputControlsLogicService")
public class InputControlsLogicServiceImpl
implements InputControlsLogicService {
    @Resource
    private HashMap<String, ControlLogic<InputControlsContainer>> controlLogicRegestry;
    @Resource
    private HashMap<String, String> controlLogicUriMapping;
    @Resource
    private HashMap<String, String> controlLogicReportTypeMapping;
    @Resource
    private String defaultControlLogicName;
    @Resource
    private ControlLogicCacheManager controlLogicCacheManager;
    @Resource
    private CachedRepositoryService cachedRepositoryService;
    @Resource(name="concreteSecurityContextProvider")
    protected SecurityContextProvider securityContextProvider;
    @Resource
    protected EvaluationEventsHandler defaultEvaluationEventsHandler;

    @Override
    public Map<String, Object> getTypedParameters(String containerUri, final Map<String, String[]> requestParameters, final boolean skipValidation) throws CascadeResourceNotFoundException, InputControlsValidationException {
        return this.callControlLogic(containerUri, new ControLogicCaller<Map<String, Object>>(){

            @Override
            public Map<String, Object> callByContainerUri(ControlLogic<InputControlsContainer> controlLogic, String containerUri) throws CascadeResourceNotFoundException, InputControlsValidationException {
                return controlLogic.getTypedParameters((InputControlsContainer)containerUri, (Map<String, String[]>)requestParameters, skipValidation);
            }

            @Override
            public Map<String, Object> callByContainer(ControlLogic<InputControlsContainer> controlLogic, InputControlsContainer container) throws CascadeResourceNotFoundException, InputControlsValidationException {
                return controlLogic.getTypedParameters(container, (Map<String, String[]>)requestParameters, skipValidation);
            }
        });
    }

    @Override
    public Map<String, Object> getTypedParameters(String containerUri, Map<String, String[]> requestParameters) throws CascadeResourceNotFoundException, InputControlsValidationException {
        return this.getTypedParameters(containerUri, requestParameters, false);
    }

    @Override
    public Map<String, String[]> formatTypedParameters(String containerUri, final Map<String, Object> requestParameters) throws CascadeResourceNotFoundException, InputControlsValidationException {
        return this.callControlLogic(containerUri, new ControLogicCaller<Map<String, String[]>>(){

            @Override
            public Map<String, String[]> callByContainerUri(ControlLogic<InputControlsContainer> controlLogic, String containerUri) throws CascadeResourceNotFoundException, InputControlsValidationException {
                return controlLogic.formatTypedParameters((InputControlsContainer)containerUri, (Map<String, Object>)requestParameters);
            }

            @Override
            public Map<String, String[]> callByContainer(ControlLogic<InputControlsContainer> controlLogic, InputControlsContainer container) throws CascadeResourceNotFoundException, InputControlsValidationException {
                return controlLogic.formatTypedParameters(container, (Map<String, Object>)requestParameters);
            }
        });
    }

    @Override
    public List<ReportInputControl> getInputControlsStructure(String containerUri, final Set<String> inputControlIds) throws CascadeResourceNotFoundException {
        this.controlLogicCacheManager.clearCache();
        try {
            return this.callControlLogic(containerUri, new ControLogicCaller<List<ReportInputControl>>(){

                @Override
                public List<ReportInputControl> callByContainerUri(ControlLogic<InputControlsContainer> controlLogic, String containerUri) throws CascadeResourceNotFoundException, InputControlsValidationException {
                    return controlLogic.getInputControlsStructure((InputControlsContainer)containerUri, (Set<String>)inputControlIds);
                }

                @Override
                public List<ReportInputControl> callByContainer(ControlLogic<InputControlsContainer> controlLogic, InputControlsContainer container) throws CascadeResourceNotFoundException, InputControlsValidationException {
                    return controlLogic.getInputControlsStructure(container, (Set<String>)inputControlIds);
                }
            });
        }
        catch (InputControlsValidationException e) {
            throw new RuntimeException("Input controls validation failed", e);
        }
    }

    @Override
    public List<ReportInputControl> getInputControlsWithValues(String reportUnitUri, Set<String> inputControlIds, Map<String, String[]> rawParameters) throws CascadeResourceNotFoundException {
        List<InputControlState> states;
        List<ReportInputControl> result = this.getInputControlsStructure(reportUnitUri, inputControlIds);
        if (result != null && !result.isEmpty() && (states = this.getValuesForInputControls(reportUnitUri, inputControlIds, rawParameters)) != null && !states.isEmpty()) {
            HashMap<String, InputControlState> statesMap = new HashMap<String, InputControlState>();
            for (InputControlState currentState : states) {
                statesMap.put(currentState.getId(), currentState);
            }
            for (ReportInputControl currentInputControl : result) {
                currentInputControl.setState((InputControlState)statesMap.get(currentInputControl.getId()));
            }
        }
        return result;
    }

    @Override
    public synchronized List<ReportInputControl> reorderInputControls(String containerUri, List<String> newOrder) throws CascadeResourceNotFoundException, InputControlsValidationException {
        List<ReportInputControl> existing = this.getInputControlsStructure(containerUri, null);
        ArrayList<ReportInputControl> reordered = new ArrayList<ReportInputControl>(existing.size());
        reordered.addAll(existing);
        if (existing.size() != newOrder.size()) {
            ValidationErrorsImpl errors = new ValidationErrorsImpl();
            errors.add((ValidationError)new InputControlValidationError("size.not.equal", null, "", null, null));
            throw new InputControlsValidationException((ValidationErrors)errors);
        }
        int[] reorderingMapping = new int[newOrder.size()];
        HashSet<String> matchedIds = new HashSet<String>();
        for (int newIndex = 0; newIndex < newOrder.size(); ++newIndex) {
            for (int oldIndex = 0; oldIndex < newOrder.size(); ++oldIndex) {
                if (!existing.get(oldIndex).getId().equals(newOrder.get(newIndex))) continue;
                if (oldIndex != newIndex) {
                    ReportInputControl t = (ReportInputControl)reordered.remove(oldIndex);
                    if (newIndex == existing.size()) {
                        reordered.add(t);
                    } else {
                        reordered.add(newIndex, t);
                    }
                }
                reorderingMapping[newIndex] = oldIndex;
                matchedIds.add(newOrder.get(newIndex));
            }
        }
        if (matchedIds.size() != existing.size()) {
            ValidationErrorsImpl errors = new ValidationErrorsImpl();
            errors.add((ValidationError)new InputControlValidationError("ids.not.match", null, null, "", null));
            throw new InputControlsValidationException((ValidationErrors)errors);
        }
        this.reorderControlsInternal(containerUri, reorderingMapping);
        return reordered;
    }

    @Override
    public List<InputControlState> getValuesForInputControls(String containerUri, final Set<String> inputControlIds, final Map<String, String[]> parameters) throws CascadeResourceNotFoundException {
        List<InputControlState> states;
        this.defaultEvaluationEventsHandler.beforeEvaluation(containerUri, parameters, this.securityContextProvider.getContextUser());
        try {
            states = this.callControlLogic(containerUri, new ControLogicCaller<List<InputControlState>>(){

                @Override
                public List<InputControlState> callByContainerUri(ControlLogic<InputControlsContainer> controlLogic, String containerUri) throws CascadeResourceNotFoundException, InputControlsValidationException {
                    return controlLogic.getValuesForInputControlsFromRawData((InputControlsContainer)containerUri, (Set<String>)inputControlIds, (Map<String, String[]>)parameters);
                }

                @Override
                public List<InputControlState> callByContainer(ControlLogic<InputControlsContainer> controlLogic, InputControlsContainer container) throws CascadeResourceNotFoundException, InputControlsValidationException {
                    return controlLogic.getValuesForInputControlsFromRawData(container, (Set<String>)inputControlIds, (Map<String, String[]>)parameters);
                }
            });
        }
        catch (InputControlsValidationException e) {
            throw new RuntimeException(e);
        }
        this.defaultEvaluationEventsHandler.afterEvaluation(containerUri, parameters, states, this.securityContextProvider.getContextUser());
        return states;
    }

    protected void reorderControlsInternal(String containerUri, int[] reorderMapping) throws CascadeResourceNotFoundException {
        InputControlsContainer container = this.cachedRepositoryService.getResource(InputControlsContainer.class, containerUri);
        List inputControls = container.getInputControls();
        LinkedList reordered = new LinkedList();
        if (inputControls.size() == reorderMapping.length) {
            for (int i = 0; i < reorderMapping.length; ++i) {
                reordered.add(inputControls.get(reorderMapping[i]));
            }
            container.setInputControls(reordered);
            this.cachedRepositoryService.updateResource((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)container);
        }
    }

    protected String getControlLogicAliasByContainerUri(String containerUri) {
        String controlLogicAlias = null;
        if (!this.controlLogicUriMapping.isEmpty()) {
            for (String currentyUriMappingExpression : this.controlLogicUriMapping.keySet()) {
                if (!Pattern.matches(currentyUriMappingExpression, containerUri)) continue;
                controlLogicAlias = this.controlLogicUriMapping.get(currentyUriMappingExpression);
                break;
            }
        }
        return controlLogicAlias;
    }

    protected <T> T callControlLogic(String containerUri, ControLogicCaller<T> caller) throws CascadeResourceNotFoundException, InputControlsValidationException {
        T result;
        String controlLogicAlias = this.getControlLogicAliasByContainerUri(containerUri);
        if (controlLogicAlias != null) {
            result = caller.callByContainerUri(this.getControlLogicByAlias(controlLogicAlias), containerUri);
        } else {
            InputControlsContainer container = this.cachedRepositoryService.getResource(InputControlsContainer.class, containerUri);
            controlLogicAlias = this.controlLogicReportTypeMapping.get(container.getResourceType());
            if (controlLogicAlias == null) {
                controlLogicAlias = this.defaultControlLogicName;
            }
            result = caller.callByContainer(this.getControlLogicByAlias(controlLogicAlias), container);
        }
        return result;
    }

    protected ControlLogic<InputControlsContainer> getControlLogicByAlias(String controlLogicAlias) {
        ControlLogic<InputControlsContainer> controlLogic = this.controlLogicRegestry.get(controlLogicAlias);
        if (controlLogic == null) {
            throw new IllegalStateException("Control logic for alias '" + controlLogicAlias + "' not found");
        }
        return controlLogic;
    }

    protected static interface ControLogicCaller<T> {
        public T callByContainerUri(ControlLogic<InputControlsContainer> var1, String var2) throws CascadeResourceNotFoundException, InputControlsValidationException;

        public T callByContainer(ControlLogic<InputControlsContainer> var1, InputControlsContainer var2) throws CascadeResourceNotFoundException, InputControlsValidationException;
    }
}

