/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers;

import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationException;
import com.jaspersoft.jasperserver.war.cascade.handlers.SingleSelectListInputControlHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MultiSelectListInputControlHandler
extends SingleSelectListInputControlHandler {
    @Override
    protected Object internalConvertParameterValueFromRawData(String[] rawData, InputControl inputControl, ReportInputControlInformation info) throws CascadeResourceNotFoundException, InputControlValidationException {
        ArrayList<Object> result = null;
        if (rawData != null) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (String currentRawValue : rawData) {
                try {
                    values.add(this.dataConverterService.convertSingleValue(currentRawValue, inputControl, info));
                }
                catch (InputControlValidationException e) {
                    // empty catch block
                }
            }
            result = values;
        }
        return result;
    }

    @Override
    protected void internalValidateValue(Object value, InputControl inputControl, ReportInputControlInformation info) throws InputControlValidationException, CascadeResourceNotFoundException {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            ArrayList invalidValues = new ArrayList();
            for (Object o : collection) {
                try {
                    super.internalValidateValue(o, inputControl, info);
                }
                catch (InputControlValidationException e) {
                    invalidValues.add(o);
                }
            }
            collection.removeAll(invalidValues);
        }
    }

    @Override
    protected Boolean hasValue(Object value) {
        return value instanceof Collection && !((Collection)value).isEmpty();
    }

    @Override
    public String[] formatValue(Object typedValue, InputControl control, ReportInputControlInformation info) throws CascadeResourceNotFoundException {
        if (typedValue instanceof Collection) {
            Collection values = (Collection)typedValue;
            ArrayList<String> strings = new ArrayList<String>();
            for (Object currentValue : values) {
                strings.add(this.dataConverterService.formatSingleValue(currentValue, control, info));
            }
            return strings.toArray(new String[strings.size()]);
        }
        if (typedValue == null) {
            return new String[0];
        }
        throw new IllegalArgumentException("Value for MultiSelect control cannot be " + typedValue.getClass().getName() + ", it should be a Collection.");
    }

    @Override
    protected Boolean matches(Object valueToCheck, Object selected) {
        Boolean result = false;
        if (selected instanceof Collection) {
            Collection selectedValues = (Collection)selected;
            for (Object currentSelectedValue : selectedValues) {
                if (!super.matches(valueToCheck, currentSelectedValue).booleanValue()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    protected Boolean isNothingSelected(String inputControlName, Map<String, Object> incomingParameters) {
        Object incomingValue = incomingParameters.get(inputControlName);
        return incomingValue instanceof Collection && ((Collection)incomingValue).isEmpty();
    }

    @Override
    public boolean isNothingSelected(String[] rawData) {
        return rawData != null && rawData.length == 0 || super.isNothingSelected(rawData);
    }

    @Override
    public void applyNothingSelected(String controlName, Map<String, Object> parameters) {
        parameters.put(controlName, Collections.emptyList());
    }

    @Override
    protected Boolean shouldAddNothinSelectedOption(InputControl inputControl) {
        return false;
    }

    @Override
    protected Object getConcreteSelectedValue(List<Object> selectedValues) {
        return selectedValues;
    }

    @Override
    protected void internalApplyNothingSubstitution(String controlName, Map<String, Object> parameters) {
    }
}

