/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers.validators;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationException;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverterService;
import com.jaspersoft.jasperserver.war.cascade.handlers.validators.InputControlValueValidator;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ComparableValidator<T extends Comparable<?>>
implements InputControlValueValidator<T> {
    @Resource
    private DataConverterService dataConverterService;
    @Resource
    protected MessageSource messageSource;

    @Override
    public void validateSingleValue(T value, DataType dataType) throws InputControlValidationException {
        if (value != null && dataType != null) {
            Locale locale = LocaleContextHolder.getLocale();
            if (dataType.getMinValue() != null) {
                Comparable<T> min = this.convertRestrictionValueToParameterType(value.getClass(), dataType.getMinValue(), dataType);
                if (dataType.isStrictMin()) {
                    if (min.compareTo(value) >= 0) {
                        throw new InputControlValidationException("fillParameters.error.smallerThan", null, this.messageSource.getMessage("fillParameters.error.smallerThan", null, locale), null);
                    }
                } else if (min.compareTo(value) > 0) {
                    throw new InputControlValidationException("fillParameters.error.smallerOrEqual", null, this.messageSource.getMessage("fillParameters.error.smallerOrEqual", null, locale), null);
                }
            }
            if (dataType.getMaxValue() != null) {
                Comparable<T> max = this.convertRestrictionValueToParameterType(value.getClass(), dataType.getMaxValue(), dataType);
                if (dataType.isStrictMax()) {
                    if (max.compareTo(value) <= 0) {
                        throw new InputControlValidationException("fillParameters.error.greaterThan", null, this.messageSource.getMessage("fillParameters.error.greaterThan", null, locale), null);
                    }
                } else if (max.compareTo(value) < 0) {
                    throw new InputControlValidationException("fillParameters.error.greaterOrEqual", null, this.messageSource.getMessage("fillParameters.error.greaterOrEqual", null, locale), null);
                }
            }
        }
    }

    protected Comparable<T> convertRestrictionValueToParameterType(Class<?> type, Object restrictionValue, DataType dataType) {
        Comparable result;
        Class<?> restrictionValueClass = restrictionValue.getClass();
        if (restrictionValueClass.isAssignableFrom(type)) {
            result = (Comparable)restrictionValue;
        } else if (restrictionValue instanceof String) {
            try {
                result = (Comparable)this.dataConverterService.convertSingleValue((String)restrictionValue, dataType, type);
            }
            catch (Exception e) {
                throw new IllegalStateException("Value '" + restrictionValue + "' couldn't be used as restriction for input control of type " + type.getName());
            }
        } else {
            throw new JSException("Restriction type " + restrictionValueClass.getName() + " incompatible with value type " + type.getName());
        }
        return result;
    }
}

