/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.common;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class ConfigurationBean {
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messages;
    private int paginatorItemsPerPage;
    private int paginatorPagesRange;
    private boolean reportLevelConfigurable;
    private boolean paginationForSinglePageReport;
    private String calendarInputJsp;
    private int userItemsPerPage;
    private int roleItemsPerPage;
    private int tenantItemsPerPage;
    private String userNameNotSupportedSymbols;
    private String roleNameNotSupportedSymbols;
    private String userNameSeparator;
    private String defaultRole;
    private String passwordMask;
    private List viewReportsFilterList;
    private List outputFolderFilterList;
    private List outputFolderFilterPatterns;
    private String tenantNameNotSupportedSymbols;
    private String tenantIdNotSupportedSymbols;
    private String resourceIdNotSupportedSymbols;
    private String publicFolderUri;
    private String themeDefaultName;
    private String themeFolderName;
    private String themeServletPrefix;
    private String dateFormat;
    private String currentYearDateFormat;
    private String timestampFormat;
    private String timeFormat;
    private int entitiesPerPage;
    private String tempFolderUri;
    private String organizationsFolderUri;
    private Map neededRolesForResourceCreation;
    private String jdbcDriversFolderUri;
    private String emailRegExpPattern;
    private boolean enableSaveToHostFS;
    private static final DataSourceType[] DATA_SOURCE_TYPES = new DataSourceType[]{new DataSourceType(JdbcReportDataSource.class, JasperServerConstImpl.getJDBCDatasourceType(), "dataSource.jdbc"), new DataSourceType(JndiJdbcReportDataSource.class, JasperServerConstImpl.getJNDIDatasourceType(), "dataSource.jndi"), new DataSourceType(VirtualReportDataSource.class, JasperServerConstImpl.getVirtualDatasourceType(), "dataSource.virtual"), new DataSourceType(JdbcReportDataSource.class, JasperServerConstImpl.getAwsDatasourceType(), "dataSource.aws"), new DataSourceType(BeanReportDataSource.class, JasperServerConstImpl.getBeanDatasourceType(), "dataSource.bean")};

    public boolean isReportLevelConfigurable() {
        return this.reportLevelConfigurable;
    }

    public void setReportLevelConfigurable(boolean reportLevelConfigurable) {
        this.reportLevelConfigurable = reportLevelConfigurable;
    }

    public Map getAllFileResourceTypes() {
        LinkedHashMap<String, String> allTypes = new LinkedHashMap<String, String>();
        allTypes.put("accessGrantSchema", this.messages.getMessage("resourceTypes.access.grant.schema", null, "Access Grant Schema", LocaleContextHolder.getLocale()));
        allTypes.put("contentResource", this.messages.getMessage("resource.com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource.label", null, "Content Resource", LocaleContextHolder.getLocale()));
        allTypes.put("css", this.messages.getMessage("resourceTypes.css.file", null, "CSS File", LocaleContextHolder.getLocale()));
        allTypes.put("font", this.messages.getMessage("resourceTypes.font", null, "Font", LocaleContextHolder.getLocale()));
        allTypes.put("img", this.messages.getMessage("resourceTypes.image", null, "Image", LocaleContextHolder.getLocale()));
        allTypes.put("jar", this.messages.getMessage("resourceTypes.jar", null, "Jar", LocaleContextHolder.getLocale()));
        allTypes.put("jrxml", this.messages.getMessage("resourceTypes.jrxml", null, "Jrxml", LocaleContextHolder.getLocale()));
        allTypes.put("olapMondrianSchema", this.messages.getMessage("resourceTypes.olap.schema", null, "OLAP Schema", LocaleContextHolder.getLocale()));
        allTypes.put("prop", this.messages.getMessage("resourceTypes.resource.bundle", null, "Properties", LocaleContextHolder.getLocale()));
        allTypes.put("jrtx", this.messages.getMessage("resourceTypes.style.template", null, "Style Template", LocaleContextHolder.getLocale()));
        allTypes.put("xml", this.messages.getMessage("resourceTypes.xml.file", null, "XML File", LocaleContextHolder.getLocale()));
        allTypes.put("contentResource", this.messages.getMessage("resource.com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource.label", null, "Content Resource", LocaleContextHolder.getLocale()));
        return allTypes;
    }

    public List getDataSourceTypes() {
        ArrayList<DataSourceType> types = new ArrayList<DataSourceType>(DATA_SOURCE_TYPES.length);
        for (int i = 0; i < DATA_SOURCE_TYPES.length; ++i) {
            types.add(DATA_SOURCE_TYPES[i]);
        }
        return types;
    }

    public int getPaginatorItemsPerPage() {
        return this.paginatorItemsPerPage;
    }

    public void setPaginatorItemsPerPage(int paginatorItemsPerPage) {
        this.paginatorItemsPerPage = paginatorItemsPerPage;
    }

    public int getPaginatorPagesRange() {
        return this.paginatorPagesRange;
    }

    public void setPaginatorPagesRange(int paginatorPagesRange) {
        this.paginatorPagesRange = paginatorPagesRange;
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public boolean isPaginationForSinglePageReport() {
        return this.paginationForSinglePageReport;
    }

    public void setPaginationForSinglePageReport(boolean paginationForSinglePageReport) {
        this.paginationForSinglePageReport = paginationForSinglePageReport;
    }

    public String getCalendarInputJsp() {
        return this.calendarInputJsp;
    }

    public void setCalendarInputJsp(String calendarInputJsp) {
        this.calendarInputJsp = calendarInputJsp;
    }

    public int getUserItemsPerPage() {
        return this.userItemsPerPage;
    }

    public void setUserItemsPerPage(int userItemsPerPage) {
        this.userItemsPerPage = userItemsPerPage;
    }

    public int getRoleItemsPerPage() {
        return this.roleItemsPerPage;
    }

    public void setRoleItemsPerPage(int roleItemsPerPage) {
        this.roleItemsPerPage = roleItemsPerPage;
    }

    public int getTenantItemsPerPage() {
        return this.tenantItemsPerPage;
    }

    public void setTenantItemsPerPage(int tenantItemsPerPage) {
        this.tenantItemsPerPage = tenantItemsPerPage;
    }

    public String getUserNameSeparator() {
        return this.userNameSeparator;
    }

    public void setUserNameSeparator(String userNameSeparator) {
        this.userNameSeparator = userNameSeparator;
    }

    public String getUserNameNotSupportedSymbols() {
        return this.userNameNotSupportedSymbols;
    }

    public void setUserNameNotSupportedSymbols(String userNameNotSupportedSymbols) {
        this.userNameNotSupportedSymbols = userNameNotSupportedSymbols;
    }

    public String getRoleNameNotSupportedSymbols() {
        return this.roleNameNotSupportedSymbols;
    }

    public void setRoleNameNotSupportedSymbols(String roleNameNotSupportedSymbols) {
        this.roleNameNotSupportedSymbols = roleNameNotSupportedSymbols;
    }

    public String getDefaultRole() {
        return this.defaultRole;
    }

    public void setDefaultRole(String defaultRole) {
        this.defaultRole = defaultRole;
    }

    public String getPasswordMask() {
        return this.passwordMask;
    }

    public void setPasswordMask(String passwordMask) {
        this.passwordMask = passwordMask;
    }

    public List getViewReportsFilterList() {
        return this.viewReportsFilterList;
    }

    public void setViewReportsFilterList(List viewReportsFilterList) {
        this.viewReportsFilterList = viewReportsFilterList;
    }

    public List getOutputFolderFilterList() {
        return this.outputFolderFilterList;
    }

    public void setOutputFolderFilterList(List outputFolderFilterList) {
        this.outputFolderFilterList = outputFolderFilterList;
        this.compileOutputFolderFilterPatterns();
    }

    protected void compileOutputFolderFilterPatterns() {
        if (this.outputFolderFilterList == null) {
            this.outputFolderFilterPatterns = new ArrayList(0);
        } else {
            this.outputFolderFilterPatterns = new ArrayList(this.outputFolderFilterList.size());
            for (String filter : this.outputFolderFilterList) {
                Pattern filterPattern = Pattern.compile(filter);
                this.outputFolderFilterPatterns.add(filterPattern);
            }
        }
    }

    public List getOutputFolderFilterPatterns() {
        return this.outputFolderFilterPatterns;
    }

    public String getTenantNameNotSupportedSymbols() {
        return this.tenantNameNotSupportedSymbols;
    }

    public void setTenantNameNotSupportedSymbols(String tenantNameNotSupportedSymbols) {
        this.tenantNameNotSupportedSymbols = tenantNameNotSupportedSymbols;
    }

    public String getTenantIdNotSupportedSymbols() {
        return this.tenantIdNotSupportedSymbols;
    }

    public void setTenantIdNotSupportedSymbols(String tenantIdNotSupportedSymbols) {
        this.tenantIdNotSupportedSymbols = tenantIdNotSupportedSymbols;
    }

    public String getResourceIdNotSupportedSymbols() {
        return this.resourceIdNotSupportedSymbols;
    }

    public void setResourceIdNotSupportedSymbols(String resourceIdNotSupportedSymbols) {
        this.resourceIdNotSupportedSymbols = resourceIdNotSupportedSymbols;
    }

    public String getPublicFolderUri() {
        return this.publicFolderUri;
    }

    public void setPublicFolderUri(String publicFolderUri) {
        this.publicFolderUri = publicFolderUri;
    }

    public String getThemeDefaultName() {
        return this.themeDefaultName;
    }

    public void setThemeDefaultName(String themeDefaultName) {
        this.themeDefaultName = themeDefaultName;
    }

    public String getThemeFolderName() {
        return this.themeFolderName;
    }

    public void setThemeFolderName(String themeFolderName) {
        this.themeFolderName = themeFolderName;
    }

    public String getThemeServletPrefix() {
        return this.themeServletPrefix;
    }

    public void setThemeServletPrefix(String themeServletPrefix) {
        this.themeServletPrefix = themeServletPrefix;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getCurrentYearDateFormat() {
        return this.currentYearDateFormat;
    }

    public void setCurrentYearDateFormat(String currentYearDateFormat) {
        this.currentYearDateFormat = currentYearDateFormat;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public int getEntitiesPerPage() {
        return this.entitiesPerPage;
    }

    public void setEntitiesPerPage(int entitiesPerPage) {
        this.entitiesPerPage = entitiesPerPage;
    }

    public String getTempFolderUri() {
        return this.tempFolderUri;
    }

    public void setTempFolderUri(String tempFolderUri) {
        this.tempFolderUri = tempFolderUri;
    }

    public String getOrganizationsFolderUri() {
        return this.organizationsFolderUri;
    }

    public void setOrganizationsFolderUri(String organizationsFolderUri) {
        this.organizationsFolderUri = organizationsFolderUri;
    }

    public Map getNeededRolesForResourceCreation() {
        return this.neededRolesForResourceCreation;
    }

    public void setNeededRolesForResourceCreation(Map neededRolesForResourceCreation) {
        this.neededRolesForResourceCreation = neededRolesForResourceCreation;
    }

    public String getJdbcDriversFolderUri() {
        return this.jdbcDriversFolderUri;
    }

    public void setJdbcDriversFolderUri(String jdbcDriversFolderUri) {
        this.jdbcDriversFolderUri = jdbcDriversFolderUri;
    }

    public String getEmailRegExpPattern() {
        return this.emailRegExpPattern;
    }

    public void setEmailRegExpPattern(String emailRegExpPattern) {
        this.emailRegExpPattern = emailRegExpPattern;
    }

    public boolean isEnableSaveToHostFS() {
        return this.enableSaveToHostFS;
    }

    public void setEnableSaveToHostFS(boolean enableSaveToHostFS) {
        this.enableSaveToHostFS = enableSaveToHostFS;
    }

    public static class DataSourceType {
        private final Class type;
        private final String typeValue;
        private final String labelMessage;

        public DataSourceType(Class type, String typeValue, String labelMessage) {
            this.type = type;
            this.typeValue = typeValue;
            this.labelMessage = labelMessage;
        }

        public String getLabelMessage() {
            return this.labelMessage;
        }

        public Class getType() {
            return this.type;
        }

        public String getTypeValue() {
            return this.typeValue;
        }
    }
}

