/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.webflow;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.webflow.conversation.impl.SessionBindingConversationManager;
import org.springframework.webflow.execution.repository.impl.DefaultFlowExecutionRepository;
import org.springframework.webflow.executor.FlowExecutorImpl;

public class WebFlowConfigurer
implements BeanFactoryPostProcessor {
    private String flowExecutorBeanName;
    private int lockTimeoutSeconds;

    public void setFlowExecutorBeanName(String flowExecutorBeanName) {
        this.flowExecutorBeanName = flowExecutorBeanName;
    }

    public void setLockTimeoutSeconds(int lockTimeoutSeconds) {
        this.lockTimeoutSeconds = lockTimeoutSeconds;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        FlowExecutorImpl flowExecutor = this.getFlowExecutor(beanFactory);
        if (flowExecutor != null) {
            this.getConversationManager(flowExecutor).setLockTimeoutSeconds(this.lockTimeoutSeconds);
        }
    }

    private FlowExecutorImpl getFlowExecutor(ConfigurableListableBeanFactory beanFactory) {
        return (FlowExecutorImpl)beanFactory.getBean(this.flowExecutorBeanName);
    }

    public DefaultFlowExecutionRepository getExecutionRepository(FlowExecutorImpl flowExecutor) {
        return (DefaultFlowExecutionRepository)flowExecutor.getExecutionRepository();
    }

    public SessionBindingConversationManager getConversationManager(FlowExecutorImpl flowExecutor) {
        return (SessionBindingConversationManager)this.getExecutionRepository(flowExecutor).getConversationManager();
    }
}

