/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.buildomatic.crypto;

import com.jaspersoft.jasperserver.crypto.EncryptionEngine;
import com.jaspersoft.jasperserver.crypto.EncryptionProperties;
import com.jaspersoft.jasperserver.crypto.KeystoreManager;
import java.io.File;
import java.security.Key;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MasterPropertiesObfuscator
extends Task {
    public static final String ENCRYPT_FLAG = "encrypt";
    public static final String ENCRYPT_DONE_FLAG = "encrypt.done";
    public static final String PROPS_TO_ENCRYPT_PARAM = "propsToEncrypt";
    public static final String PROPS_TO_ENCRYPT_DEF = "dbPassword";
    private String propsFile;
    private String ksp = ".jrsksp";

    public void execute() throws BuildException {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(new File(this.propsFile));
            PropertiesConfigurationLayout configLayout = config.getLayout();
            configLayout.setGlobalSeparator("=");
            Boolean encFlag = Boolean.parseBoolean(config.getString(ENCRYPT_FLAG));
            Boolean encDoneFlag = Boolean.parseBoolean(config.getString(ENCRYPT_DONE_FLAG));
            if (encFlag.booleanValue() && !encDoneFlag.booleanValue()) {
                String blockSzStr = config.getString("crypto.block.size");
                EncryptionProperties encProps = new EncryptionProperties(blockSzStr != null ? Integer.valueOf(Integer.parseInt(blockSzStr)) : null, config.getString("crypto.transf"));
                List propsToEncryptList = config.getList(PROPS_TO_ENCRYPT_PARAM, Arrays.asList(PROPS_TO_ENCRYPT_DEF));
                this.log("Encrypt " + StringUtils.join((Object[])propsToEncryptList.toArray(), (char)','), 2);
                this.log("Encryption block size: " + encProps.getBlockSize(), 4);
                this.log("Encryption mode: " + encProps.getCipherTransformation(), 4);
                KeystoreManager.init((String)this.ksp);
                KeystoreManager ksManager = KeystoreManager.getInstance();
                Key secret = ksManager.getBuildKey();
                HashSet<String> paramSet = new HashSet<String>(propsToEncryptList.size());
                for (Object prop : propsToEncryptList) {
                    String propNameToEnc = prop.toString().trim();
                    if (paramSet.contains(propNameToEnc)) continue;
                    paramSet.add(propNameToEnc);
                    String pVal = config.getString(propNameToEnc);
                    if (pVal == null) continue;
                    if (EncryptionEngine.isEncrypted((String)pVal)) {
                        this.log("encrypt=true was set, but param " + propNameToEnc + " was found already encrypted. " + " Skipping its encryption.", 1);
                        continue;
                    }
                    String ct = EncryptionEngine.encrypt((Key)secret, (String)pVal, (EncryptionProperties)encProps);
                    config.setProperty(propNameToEnc, (Object)ct);
                }
                config.clearProperty(ENCRYPT_FLAG);
                config.setProperty(ENCRYPT_DONE_FLAG, (Object)"true");
                config.save();
            } else if (encDoneFlag.booleanValue()) {
                this.log("The master properties have already been encrypted. To re-enable the encryption, make sure the passwords are in plain text, set master property encrypt to true and remove encrypt.done.", 2);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    public String getKsp() {
        return this.ksp;
    }

    public void setKsp(String ksProp) {
        this.ksp = ksProp;
    }

    public String getPropsFile() {
        return this.propsFile;
    }

    public void setPropsFile(String file) {
        this.propsFile = file;
    }
}

