/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.ExponentialInterval;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.Retransmitter;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Digest;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Reliable transmission multipoint FIFO protocol")
public class NAKACK
extends Protocol
implements Retransmitter.RetransmitCommand,
DiagnosticsHandler.ProbeHandler {
    private static final int NUM_REBROADCAST_MSGS = 3;
    @Property(name="retransmit_timeout", converter=PropertyConverters.IntegerArray.class, description="Timeout before requesting retransmissions")
    private int[] retransmit_timeouts = new int[]{600, 1200, 2400, 4800};
    @Property(description="Max number of messages to be removed from a NakReceiverWindow. This property might get removed anytime, so don't use it !")
    private int max_msg_batch_size = 100;
    @Property(description="Retransmit retransmit responses (messages) using multicast rather than unicast")
    private boolean use_mcast_xmit = true;
    @Property(description="Use a multicast to request retransmission of missing messages")
    private boolean use_mcast_xmit_req = false;
    @Property(description="Number of milliseconds to delay the sending of an XMIT request. We pick a random number in the range [1 .. xmit_req_stagger_timeout] and add this to the scheduling time of an XMIT request. When use_mcast_xmit is enabled, if a number of members drop messages from the same member, then chances are that, if staggering is enabled, somebody else already sent the XMIT request (via mcast) and we can cancel the XMIT request once we receive the missing messages. For unicast XMIT responses (use_mcast_xmit=false), we still have an advantage by not overwhelming the receiver with XMIT requests, all at the same time. 0 disabless staggering.")
    protected long xmit_stagger_timeout = 200L;
    @Property(description="Ask a random member for retransmission of a missing message. Default is false")
    private boolean xmit_from_random_member = false;
    @Property(description="The first value (in milliseconds) to use in the exponential backoff. Enabled if greater than 0")
    private int exponential_backoff = 300;
    @Property(description="Whether to use the old retransmitter which retransmits individual messages or the new one which uses ranges of retransmitted messages. Default is true. Note that this property will be removed in 3.0; it is only used to switch back to the old (and proven) retransmitter mechanism if issues occur")
    private boolean use_range_based_retransmitter = true;
    @Property(description="Should messages delivered to application be discarded")
    private boolean discard_delivered_msgs = true;
    @Property(description="Timeout to rebroadcast messages. Default is 2000 msec")
    private long max_rebroadcast_timeout = 2000L;
    @Property(description="Should stability history be printed if we fail in retransmission. Default is false")
    protected boolean print_stability_history_on_failed_xmit = false;
    @Property(description="discards warnings about promiscuous traffic")
    private boolean log_discard_msgs = true;
    @Property(description="If true, trashes warnings about retransmission messages not found in the xmit_table (used for testing)")
    private boolean log_not_found_msgs = true;
    @Property(description="Number of rows of the matrix in the retransmission table (only for experts)", writable=false)
    int xmit_table_num_rows = 5;
    @Property(description="Number of elements of a row of the matrix in the retransmission table (only for experts). The capacity of the matrix is xmit_table_num_rows * xmit_table_msgs_per_row", writable=false)
    int xmit_table_msgs_per_row = 10000;
    @Property(description="Resize factor of the matrix in the retransmission table (only for experts)", writable=false)
    double xmit_table_resize_factor = 1.2;
    @Property(description="Number of milliseconds after which the matrix in the retransmission table is compacted (only for experts)", writable=false)
    long xmit_table_max_compaction_time = 600000L;
    @ManagedAttribute(description="Number of retransmit requests received")
    private final AtomicLong xmit_reqs_received = new AtomicLong(0L);
    @ManagedAttribute(description="Number of retransmit requests sent")
    private final AtomicLong xmit_reqs_sent = new AtomicLong(0L);
    @ManagedAttribute(description="Number of retransmit responses received")
    private final AtomicLong xmit_rsps_received = new AtomicLong(0L);
    @ManagedAttribute(description="Number of retransmit responses sent")
    private final AtomicLong xmit_rsps_sent = new AtomicLong(0L);
    private boolean is_server = false;
    private Address local_addr = null;
    private final List<Address> members = new CopyOnWriteArrayList<Address>();
    private View view;
    private final AtomicLong seqno = new AtomicLong(0L);
    private final ConcurrentMap<Address, NakReceiverWindow> xmit_table = Util.createConcurrentMap();
    private volatile boolean leaving = false;
    private volatile boolean running = false;
    private TimeScheduler timer = null;
    private final Lock rebroadcast_lock = new ReentrantLock();
    private final Condition rebroadcast_done = this.rebroadcast_lock.newCondition();
    private volatile boolean rebroadcasting = false;
    private final Lock rebroadcast_digest_lock = new ReentrantLock();
    private Digest rebroadcast_digest = null;
    protected final BoundedList<Digest> stability_msgs = new BoundedList(10);
    protected final BoundedList<String> digest_history = new BoundedList(10);

    public long getXmitRequestsReceived() {
        return this.xmit_reqs_received.get();
    }

    public long getXmitRequestsSent() {
        return this.xmit_reqs_sent.get();
    }

    public long getXmitResponsesReceived() {
        return this.xmit_rsps_received.get();
    }

    public long getXmitResponsesSent() {
        return this.xmit_rsps_sent.get();
    }

    @ManagedAttribute(description="Total number of missing messages")
    public int getPendingXmitRequests() {
        int num = 0;
        for (NakReceiverWindow win : this.xmit_table.values()) {
            num += win.getPendingXmits();
        }
        return num;
    }

    @ManagedAttribute
    public int getXmitTableSize() {
        int num = 0;
        for (NakReceiverWindow win : this.xmit_table.values()) {
            num += win.size();
        }
        return num;
    }

    @ManagedAttribute
    public int getXmitTableMissingMessages() {
        int num = 0;
        for (NakReceiverWindow win : this.xmit_table.values()) {
            num += win.getMissingMessages();
        }
        return num;
    }

    @ManagedAttribute(description="Returns the number of bytes of all messages in all NakReceiverWindows. To compute the size, Message.getLength() is used")
    public long getSizeOfAllMessages() {
        long retval = 0L;
        for (NakReceiverWindow win : this.xmit_table.values()) {
            retval += win.sizeOfAllMessages(false);
        }
        return retval;
    }

    @ManagedAttribute(description="Returns the number of bytes of all messages in all NakReceiverWindows. To compute the size, Message.size() is used")
    public long getSizeOfAllMessagesInclHeaders() {
        long retval = 0L;
        for (NakReceiverWindow win : this.xmit_table.values()) {
            retval += win.sizeOfAllMessages(true);
        }
        return retval;
    }

    @ManagedAttribute
    public long getCurrentSeqno() {
        return this.seqno.get();
    }

    @ManagedOperation
    public String printRetransmitStats() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(((NakReceiverWindow)entry.getValue()).printRetransmitStats()).append("\n");
        }
        return sb.toString();
    }

    public NakReceiverWindow getWindow(Address mbr) {
        return (NakReceiverWindow)this.xmit_table.get(mbr);
    }

    public void setTimer(TimeScheduler timer) {
        this.timer = timer;
    }

    @Override
    public void resetStats() {
        this.xmit_reqs_received.set(0L);
        this.xmit_reqs_sent.set(0L);
        this.xmit_rsps_received.set(0L);
        this.xmit_rsps_sent.set(0L);
        this.stability_msgs.clear();
        this.digest_history.clear();
    }

    @Override
    public void init() throws Exception {
        TP transport;
        if (this.xmit_from_random_member && this.discard_delivered_msgs) {
            this.discard_delivered_msgs = false;
            this.log.debug("xmit_from_random_member set to true: changed discard_delivered_msgs to false");
        }
        if ((transport = this.getTransport()) != null) {
            transport.registerProbeHandler(this);
            if (!transport.supportsMulticasting()) {
                if (this.use_mcast_xmit) {
                    this.log.warn("use_mcast_xmit should not be used because the transport (" + transport.getName() + ") does not support IP multicasting; setting use_mcast_xmit to false");
                    this.use_mcast_xmit = false;
                }
                if (this.use_mcast_xmit_req) {
                    this.log.warn("use_mcast_xmit_req should not be used because the transport (" + transport.getName() + ") does not support IP multicasting; setting use_mcast_xmit_req to false");
                    this.use_mcast_xmit_req = false;
                }
            }
        }
    }

    public boolean isUseMcastXmit() {
        return this.use_mcast_xmit;
    }

    public void setUseMcastXmit(boolean use_mcast_xmit) {
        this.use_mcast_xmit = use_mcast_xmit;
    }

    public boolean isXmitFromRandomMember() {
        return this.xmit_from_random_member;
    }

    public void setXmitFromRandomMember(boolean xmit_from_random_member) {
        this.xmit_from_random_member = xmit_from_random_member;
    }

    public boolean isDiscardDeliveredMsgs() {
        return this.discard_delivered_msgs;
    }

    public void setDiscardDeliveredMsgs(boolean discard_delivered_msgs) {
        this.discard_delivered_msgs = discard_delivered_msgs;
    }

    public void setLogDiscardMessages(boolean flag) {
        this.log_discard_msgs = flag;
    }

    public void setLogDiscardMsgs(boolean flag) {
        this.setLogDiscardMessages(flag);
    }

    public boolean getLogDiscardMessages() {
        return this.log_discard_msgs;
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> retval = super.dumpStats();
        retval.put("msgs", this.printMessages());
        return retval;
    }

    @Override
    public String printStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nStability messages received\n");
        sb.append(this.printStabilityMessages()).append("\n");
        return sb.toString();
    }

    @ManagedOperation(description="TODO")
    public String printStabilityMessages() {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.printListWithDelimiter(this.stability_msgs, "\n"));
        return sb.toString();
    }

    public String printStabilityHistory() {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (Digest digest : this.stability_msgs) {
            sb.append(i++).append(": ").append(digest).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Keeps information about the last N times a digest was set or merged")
    public String printDigestHistory() {
        StringBuilder sb = new StringBuilder(this.local_addr + ":\n");
        for (String tmp : this.digest_history) {
            sb.append(tmp).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="TODO")
    public String printLossRates() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            NakReceiverWindow win = (NakReceiverWindow)entry.getValue();
            sb.append(entry.getKey()).append(": ").append(win.printLossRate()).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Returns the sizes of all NakReceiverWindow.RetransmitTables")
    public String printRetransmitTableSizes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            NakReceiverWindow win = (NakReceiverWindow)entry.getValue();
            sb.append(entry.getKey() + ": ").append(win.getRetransmitTableSize()).append(", offset=").append(win.getRetransmitTableOffset()).append(" (capacity=" + win.getRetransmitTableCapacity()).append(", fill factor=" + win.getRetransmitTableFillFactor() + "%)\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Compacts the retransmission tables")
    public void compact() {
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            NakReceiverWindow win = (NakReceiverWindow)entry.getValue();
            win.compact();
        }
    }

    @Override
    public List<Integer> providedUpServices() {
        ArrayList<Integer> retval = new ArrayList<Integer>(5);
        retval.add(39);
        retval.add(41);
        retval.add(42);
        retval.add(53);
        return retval;
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        this.running = true;
        this.leaving = false;
    }

    @Override
    public void stop() {
        this.running = false;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest != null || msg.isFlagSet(Message.NO_RELIABILITY)) break;
                this.send(evt, msg);
                return null;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return null;
            }
            case 39: {
                return this.getDigest((Address)evt.getArg());
            }
            case 41: {
                this.setDigest((Digest)evt.getArg());
                return null;
            }
            case 42: {
                this.overwriteDigest((Digest)evt.getArg());
                return null;
            }
            case 53: {
                this.mergeDigest((Digest)evt.getArg());
                return null;
            }
            case 15: {
                View tmp_view = (View)evt.getArg();
                List<Address> mbrs = tmp_view.getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                break;
            }
            case 6: {
                View tmp_view = (View)evt.getArg();
                List<Address> mbrs = tmp_view.getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                this.view = tmp_view;
                this.adjustReceivers(this.members);
                this.is_server = true;
                LinkedHashSet<Address> tmp = new LinkedHashSet<Address>(this.members);
                tmp.add(null);
                break;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 4: {
                this.leaving = true;
                this.reset();
                break;
            }
            case 78: {
                this.rebroadcasting = true;
                this.rebroadcast_digest = (Digest)evt.getArg();
                try {
                    this.rebroadcastMessages();
                }
                finally {
                    this.rebroadcasting = false;
                    this.rebroadcast_digest_lock.lock();
                    try {
                        this.rebroadcast_digest = null;
                    }
                    finally {
                        this.rebroadcast_digest_lock.unlock();
                    }
                }
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                NakAckHeader hdr;
                Message msg = (Message)evt.getArg();
                if (msg.isFlagSet(Message.NO_RELIABILITY) || (hdr = (NakAckHeader)msg.getHeader(this.id)) == null) break;
                if (!this.is_server) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("message " + msg.getSrc() + "::" + hdr.seqno + " was discarded (not yet server)");
                    }
                    return null;
                }
                switch (hdr.type) {
                    case 1: {
                        this.handleMessage(msg, hdr);
                        return null;
                    }
                    case 2: {
                        if (hdr.range == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error("XMIT_REQ: range of xmit msg is null; discarding request from " + msg.getSrc());
                            }
                            return null;
                        }
                        this.handleXmitReq(msg.getSrc(), hdr.range.low, hdr.range.high, hdr.sender);
                        return null;
                    }
                    case 3: {
                        this.handleXmitRsp(msg, hdr);
                        return null;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error("NakAck header type " + hdr.type + " not known !");
                }
                return null;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return null;
            }
            case 9: {
                if (!this.rebroadcasting) break;
                this.cancelRebroadcasting();
            }
        }
        return this.up_prot.up(evt);
    }

    private void send(Event evt, Message msg) {
        block13: {
            if (msg == null) {
                throw new NullPointerException("msg is null; event is " + evt);
            }
            if (!this.running) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[" + this.local_addr + "] discarded message as we're not in the 'running' state, message: " + msg);
                }
                return;
            }
            NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.get(this.local_addr);
            if (win == null) {
                if (this.log.isWarnEnabled() && this.log_discard_msgs) {
                    this.log.warn(this.local_addr + ": discarded message to " + this.local_addr + " with no window, my view is " + this.view);
                }
                return;
            }
            if (msg.getSrc() == null) {
                msg.setSrc(this.local_addr);
            }
            long msg_id = this.seqno.incrementAndGet();
            long sleep = 500L;
            while (this.running) {
                try {
                    msg.putHeader(this.id, NakAckHeader.createMessageHeader(msg_id));
                    win.add(msg_id, msg);
                    break;
                }
                catch (Throwable t) {
                    if (this.running) {
                        Util.sleep(sleep);
                    }
                    sleep = Math.min(5000L, sleep * 2L);
                }
            }
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("sending " + this.local_addr + "#" + msg_id);
                }
                this.down_prot.down(evt);
            }
            catch (Throwable t) {
                if (!this.log.isWarnEnabled()) break block13;
                this.log.warn("failure passing message down", t);
            }
        }
    }

    private void handleMessage(Message msg, NakAckHeader hdr) {
        AtomicBoolean processing;
        boolean added;
        Address sender = msg.getSrc();
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("sender of message is null");
            }
            return;
        }
        NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.get(sender);
        if (win == null) {
            if (this.leaving) {
                return;
            }
            if (this.log.isWarnEnabled() && this.log_discard_msgs) {
                this.log.warn(this.local_addr + ": dropped message " + hdr.seqno + " from " + sender + " (sender not in table " + this.xmit_table.keySet() + "), view=" + this.view);
            }
            return;
        }
        boolean loopback = this.local_addr.equals(sender);
        boolean bl = added = loopback || win.add(hdr.seqno, msg);
        if (added && this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(": received ").append(sender).append('#').append(hdr.seqno));
        }
        if (added && msg.isFlagSet(Message.OOB)) {
            if (loopback) {
                msg = win.get(hdr.seqno);
            }
            if (msg != null && msg.isFlagSet(Message.OOB) && msg.setTransientFlagIfAbsent(Message.OOB_DELIVERED)) {
                this.up_prot.up(new Event(1, msg));
            }
        }
        if (!(processing = win.getProcessing()).compareAndSet(false, true)) {
            return;
        }
        boolean remove_msgs = this.discard_delivered_msgs && !loopback;
        boolean released_processing = false;
        try {
            block6: while (true) {
                List<Message> msgs;
                if ((msgs = win.removeMany(processing, remove_msgs, this.max_msg_batch_size)) == null || msgs.isEmpty()) {
                    released_processing = true;
                    if (this.rebroadcasting) {
                        this.checkForRebroadcasts();
                    }
                    return;
                }
                Iterator<Message> i$ = msgs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block6;
                    Message msg_to_deliver = i$.next();
                    if (msg_to_deliver.isFlagSet(Message.OOB) && !msg_to_deliver.setTransientFlagIfAbsent(Message.OOB_DELIVERED)) continue;
                    try {
                        this.up_prot.up(new Event(1, msg_to_deliver));
                    }
                    catch (Throwable t) {
                        this.log.error("couldn't deliver message " + msg_to_deliver, t);
                    }
                }
                break;
            }
        }
        finally {
            if (!released_processing) {
                processing.set(false);
            }
        }
    }

    private void handleXmitReq(Address xmit_requester, long first_seqno, long last_seqno, Address original_sender) {
        block12: {
            NakReceiverWindow win;
            block11: {
                if (first_seqno > last_seqno) {
                    return;
                }
                if (this.log.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.local_addr).append(": received xmit request from ").append(xmit_requester).append(" for ");
                    sb.append(original_sender).append(" [").append(first_seqno).append(" - ").append(last_seqno).append("]");
                    this.log.trace(sb.toString());
                }
                if (this.stats) {
                    this.xmit_reqs_received.addAndGet(last_seqno - first_seqno + 1L);
                }
                if ((win = (NakReceiverWindow)this.xmit_table.get(original_sender)) == null) {
                    if (this.log.isErrorEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("(requester=").append(xmit_requester).append(", local_addr=").append(this.local_addr);
                        sb.append(") ").append(original_sender).append(" not found in retransmission table");
                        if (this.log.isTraceEnabled()) {
                            sb.append(":\n").append(this.printMessages());
                        }
                        if (this.print_stability_history_on_failed_xmit) {
                            sb.append(" (stability history:\n").append(this.printStabilityHistory());
                        }
                        this.log.error(sb.toString());
                    }
                    return;
                }
                long diff = last_seqno - first_seqno + 1L;
                if (diff < 10L) break block11;
                List<Message> msgs = win.get(first_seqno, last_seqno);
                if (msgs == null) break block12;
                for (Message msg : msgs) {
                    this.sendXmitRsp(xmit_requester, msg);
                }
                break block12;
            }
            for (long i = first_seqno; i <= last_seqno; ++i) {
                Message msg = win.get(i);
                if (msg == null) {
                    if (!this.log.isWarnEnabled() || !this.log_not_found_msgs || this.local_addr.equals(xmit_requester)) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("(requester=").append(xmit_requester).append(", local_addr=").append(this.local_addr);
                    sb.append(") message ").append(original_sender).append("::").append(i);
                    sb.append(" not found in retransmission table of ").append(original_sender).append(":\n").append(win);
                    if (this.print_stability_history_on_failed_xmit) {
                        sb.append(" (stability history:\n").append(this.printStabilityHistory());
                    }
                    this.log.warn(sb.toString());
                    continue;
                }
                this.sendXmitRsp(xmit_requester, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRebroadcasting() {
        this.rebroadcast_lock.lock();
        try {
            this.rebroadcasting = false;
            this.rebroadcast_done.signalAll();
        }
        finally {
            this.rebroadcast_lock.unlock();
        }
    }

    private void sendXmitRsp(Address dest, Message msg) {
        if (msg == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("message is null, cannot send retransmission");
            }
            return;
        }
        if (this.stats) {
            this.xmit_rsps_sent.incrementAndGet();
        }
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if (this.use_mcast_xmit) {
            this.down_prot.down(new Event(1, msg));
            return;
        }
        Message xmit_msg = msg.copy(true, true);
        xmit_msg.setDest(dest);
        NakAckHeader hdr = (NakAckHeader)xmit_msg.getHeader(this.id);
        hdr.type = (byte)3;
        this.down_prot.down(new Event(1, xmit_msg));
    }

    private void handleXmitRsp(Message msg, NakAckHeader hdr) {
        block5: {
            if (msg == null) {
                return;
            }
            try {
                if (this.stats) {
                    this.xmit_rsps_received.incrementAndGet();
                }
                msg.setDest(null);
                hdr.type = 1;
                this.up(new Event(1, msg));
                if (this.rebroadcasting) {
                    this.checkForRebroadcasts();
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error("failed reading retransmitted message", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rebroadcastMessages() {
        long sleep = this.max_rebroadcast_timeout / 3L;
        long wait_time = this.max_rebroadcast_timeout;
        long start = System.currentTimeMillis();
        while (wait_time > 0L) {
            Digest their_digest;
            this.rebroadcast_digest_lock.lock();
            try {
                if (this.rebroadcast_digest == null) {
                    return;
                }
                their_digest = this.rebroadcast_digest.copy();
            }
            finally {
                this.rebroadcast_digest_lock.unlock();
            }
            Digest my_digest = this.getDigest();
            boolean xmitted = false;
            for (Digest.DigestEntry entry : their_digest) {
                long my_high;
                long their_high;
                Address member = entry.getMember();
                long[] my_entry = my_digest.get(member);
                if (my_entry == null || (their_high = entry.getHighest()) <= (my_high = Math.max(1L, Math.max(my_entry[0], my_entry[1]) + 1L))) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[" + this.local_addr + "] fetching " + my_high + "-" + their_high + " from " + member);
                }
                this.retransmit(my_high, their_high, member, true);
                xmitted = true;
            }
            if (!xmitted) {
                return;
            }
            this.rebroadcast_lock.lock();
            try {
                my_digest = this.getDigest();
                this.rebroadcast_digest_lock.lock();
                try {
                    if (!this.rebroadcasting || my_digest.isGreaterThanOrEqual(this.rebroadcast_digest)) {
                        this.rebroadcast_digest_lock.unlock();
                        this.rebroadcast_lock.unlock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    this.rebroadcast_digest_lock.unlock();
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            this.rebroadcast_digest_lock.unlock();
            this.rebroadcast_done.await(sleep, TimeUnit.MILLISECONDS);
            wait_time -= System.currentTimeMillis() - start;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForRebroadcasts() {
        boolean cancel_rebroadcasting;
        Digest tmp = this.getDigest();
        this.rebroadcast_digest_lock.lock();
        try {
            cancel_rebroadcasting = tmp.isGreaterThanOrEqual(this.rebroadcast_digest);
        }
        finally {
            this.rebroadcast_digest_lock.unlock();
        }
        if (cancel_rebroadcasting) {
            this.cancelRebroadcasting();
        }
    }

    private void adjustReceivers(List<Address> new_members) {
        for (Address member : this.xmit_table.keySet()) {
            NakReceiverWindow win;
            if (new_members.contains(member) || this.local_addr != null && this.local_addr.equals(member) || (win = (NakReceiverWindow)this.xmit_table.remove(member)) == null) continue;
            win.destroy();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("removed " + member + " from xmit_table (not member anymore)");
        }
    }

    public Digest getDigest() {
        HashMap<Address, long[]> map = new HashMap<Address, long[]>();
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            Address sender = (Address)entry.getKey();
            NakReceiverWindow win = (NakReceiverWindow)entry.getValue();
            long[] seqnos = win.getDigest();
            map.put(sender, seqnos);
        }
        return new Digest(map);
    }

    public Digest getDigest(Address mbr) {
        if (mbr == null) {
            return this.getDigest();
        }
        NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.get(mbr);
        if (win == null) {
            return null;
        }
        long[] seqnos = win.getDigest();
        return new Digest(mbr, seqnos[0], seqnos[1]);
    }

    private void setDigest(Digest digest) {
        this.setDigest(digest, false);
    }

    private void mergeDigest(Digest digest) {
        this.setDigest(digest, true);
    }

    private void overwriteDigest(Digest digest) {
        if (digest == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("\n[overwriteDigest()]\n");
        sb.append("existing digest:  " + this.getDigest()).append("\nnew digest:       " + digest);
        for (Digest.DigestEntry entry : digest) {
            Address member = entry.getMember();
            if (member == null) continue;
            long highest_delivered_seqno = entry.getHighestDeliveredSeqno();
            NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.get(member);
            if (win != null) {
                if (this.local_addr.equals(member)) {
                    win.setHighestDelivered(highest_delivered_seqno);
                    continue;
                }
                this.xmit_table.remove(member);
                win.destroy();
            }
            win = this.createNakReceiverWindow(member, highest_delivered_seqno);
            this.xmit_table.put(member, win);
        }
        sb.append("\n").append("resulting digest: " + this.getDigest());
        this.digest_history.add(sb.toString());
        if (this.log.isDebugEnabled()) {
            this.log.debug(sb.toString());
        }
    }

    private void setDigest(Digest digest, boolean merge) {
        if (digest == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(merge ? "\n[mergeDigest()]\n" : "\n[setDigest()]\n");
        sb.append("existing digest:  " + this.getDigest()).append("\nnew digest:       " + digest);
        boolean set_own_seqno = false;
        for (Digest.DigestEntry entry : digest) {
            Address member = entry.getMember();
            if (member == null) continue;
            long highest_delivered_seqno = entry.getHighestDeliveredSeqno();
            NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.get(member);
            if (win != null) {
                if (!merge || this.local_addr != null && this.local_addr.equals(member) || win.getHighestDelivered() >= highest_delivered_seqno) continue;
                this.xmit_table.remove(member);
                win.destroy();
                if (member.equals(this.local_addr)) {
                    this.seqno.set(highest_delivered_seqno);
                    set_own_seqno = true;
                }
            }
            win = this.createNakReceiverWindow(member, highest_delivered_seqno);
            this.xmit_table.put(member, win);
        }
        sb.append("\n").append("resulting digest: " + this.getDigest());
        if (set_own_seqno) {
            sb.append("\nnew seqno for " + this.local_addr + ": " + this.seqno);
        }
        this.digest_history.add(sb.toString());
        if (this.log.isDebugEnabled()) {
            this.log.debug(sb.toString());
        }
    }

    private NakReceiverWindow createNakReceiverWindow(Address sender, long initial_seqno) {
        NakReceiverWindow win = new NakReceiverWindow(sender, this, initial_seqno, this.timer, this.use_range_based_retransmitter, this.xmit_table_num_rows, this.xmit_table_msgs_per_row, this.xmit_table_resize_factor, this.xmit_table_max_compaction_time, false);
        if (this.exponential_backoff > 0) {
            win.setRetransmitTimeouts(new ExponentialInterval(this.exponential_backoff));
        } else {
            win.setRetransmitTimeouts(new StaticInterval(this.retransmit_timeouts));
        }
        if (this.xmit_stagger_timeout > 0L) {
            win.setXmitStaggerTimeout(this.xmit_stagger_timeout);
        }
        return win;
    }

    private void stable(Digest digest) {
        if (this.members == null || this.local_addr == null || digest == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("members, local_addr or digest are null !");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("received stable digest " + digest);
        }
        this.stability_msgs.add(digest);
        for (Digest.DigestEntry entry : digest) {
            Address member = entry.getMember();
            if (member == null) continue;
            long high_seqno_delivered = entry.getHighestDeliveredSeqno();
            long high_seqno_received = entry.getHighestReceivedSeqno();
            NakReceiverWindow recv_win = (NakReceiverWindow)this.xmit_table.get(member);
            if (recv_win != null) {
                long my_highest_rcvd = recv_win.getHighestReceived();
                long stability_highest_rcvd = high_seqno_received;
                if (stability_highest_rcvd >= 0L && stability_highest_rcvd > my_highest_rcvd) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("my_highest_rcvd (" + my_highest_rcvd + ") < stability_highest_rcvd (" + stability_highest_rcvd + "): requesting retransmission of " + member + '#' + stability_highest_rcvd);
                    }
                    this.retransmit(stability_highest_rcvd, stability_highest_rcvd, member);
                }
            }
            if (high_seqno_delivered < 0L) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace("deleting msgs <= " + high_seqno_delivered + " from " + member);
            }
            if (recv_win == null) continue;
            recv_win.stable(high_seqno_delivered);
        }
    }

    @Override
    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        if (first_seqno <= last_seqno) {
            this.retransmit(first_seqno, last_seqno, sender, false);
        }
    }

    protected void retransmit(long first_seqno, long last_seqno, Address sender, boolean multicast_xmit_request) {
        Address random_member;
        Address dest = sender;
        if (multicast_xmit_request || this.use_mcast_xmit_req) {
            dest = null;
        } else if (this.xmit_from_random_member && !this.local_addr.equals(sender) && (random_member = (Address)Util.pickRandomElement(this.members)) != null && !this.local_addr.equals(random_member)) {
            dest = random_member;
            if (this.log.isTraceEnabled()) {
                this.log.trace("picked random member " + dest + " to send XMIT request to");
            }
        }
        NakAckHeader hdr = NakAckHeader.createXmitRequestHeader(first_seqno, last_seqno, sender);
        Message retransmit_msg = new Message(dest, null, null);
        retransmit_msg.setFlag(Message.OOB);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": sending XMIT_REQ ([" + first_seqno + ", " + last_seqno + "]) to " + dest);
        }
        retransmit_msg.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, retransmit_msg));
        if (this.stats) {
            this.xmit_reqs_sent.addAndGet(last_seqno - first_seqno + 1L);
        }
    }

    private void reset() {
        this.seqno.set(0L);
        for (NakReceiverWindow win : this.xmit_table.values()) {
            win.destroy();
        }
        this.xmit_table.clear();
    }

    @ManagedOperation(description="Prints the contents of the receiver windows for all members")
    public String printMessages() {
        StringBuilder ret = new StringBuilder(this.local_addr + ":\n");
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            NakReceiverWindow win = (NakReceiverWindow)entry.getValue();
            ret.append(addr).append(": ").append(win.toString()).append('\n');
        }
        return ret.toString();
    }

    @Override
    public Map<String, String> handleProbe(String ... keys) {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (String key : keys) {
            if (key.equals("digest-history")) {
                retval.put(key, this.printDigestHistory());
            }
            if (!key.equals("dump-digest")) continue;
            retval.put(key, "\n" + this.printMessages());
        }
        return retval;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{"digest-history", "dump-digest"};
    }
}

