/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.BaseExporterImporter;
import com.jaspersoft.jasperserver.export.ExportTask;
import com.jaspersoft.jasperserver.export.Exporter;
import com.jaspersoft.jasperserver.export.io.ExportOutput;
import com.jaspersoft.jasperserver.export.modules.ExporterModule;
import com.jaspersoft.jasperserver.export.modules.ExporterModuleContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ExporterImpl
extends BaseExporterImporter
implements Exporter {
    private static final Log log = LogFactory.getLog(ExporterImpl.class);
    private String xmlVersion;
    protected ExportTask task;
    protected ExportOutput output;
    private Element indexRootElement;
    private Map moduleIndexElements;

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public Element getIndexRootElement() {
        return this.indexRootElement;
    }

    protected Element getIndexModuleElement(String moduleId) {
        return (Element)this.moduleIndexElements.get(moduleId);
    }

    public ExportTask getExportTask() {
        return this.task;
    }

    @Override
    public void setTask(ExportTask task) {
        this.task = task;
        this.output = task == null ? null : task.getOutput();
    }

    public ExportOutput getOutput() {
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performExport() {
        try {
            this.output.open();
            boolean close = true;
            try {
                this.process();
                close = false;
                this.output.close();
            }
            finally {
                if (close) {
                    try {
                        this.output.close();
                    }
                    catch (IOException ioe) {
                        log.info((Object)"Error while closing output", (Throwable)ioe);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected void process() {
        Document indexDocument = DocumentHelper.createDocument();
        this.indexRootElement = indexDocument.addElement(this.getIndexRootElementName());
        this.setOutputProperties();
        this.invokeModules();
        this.writeIndexDocument(indexDocument);
    }

    protected void setOutputProperties() {
        Properties properties = this.output.getOutputProperties();
        Enumeration<?> it = properties.propertyNames();
        while (it.hasMoreElements()) {
            String property = (String)it.nextElement();
            String value = properties.getProperty(property);
            this.setOutputProperty(property, value);
        }
        String version = super.getJsVersion();
        if (version != null && !version.equals("")) {
            this.setOutputProperty("jsVersion", version);
        }
    }

    protected void setOutputProperty(String property, String value) {
        Element propElement = this.indexRootElement.addElement(this.getPropertyElementName());
        propElement.addAttribute(this.getPropertyNameAttribute(), property);
        if (value != null) {
            propElement.addAttribute(this.getPropertyValueAttribute(), value);
        }
    }

    protected void invokeModules() {
        List modules = this.getModuleRegister().getExporterModules();
        this.moduleIndexElements = new HashMap();
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            if (Thread.interrupted()) {
                throw new RuntimeException("Cancelled");
            }
            ExporterModule module = (ExporterModule)it.next();
            ModuleContextImpl moduleContext = new ModuleContextImpl(module.getId());
            module.init(moduleContext);
            if (!module.toProcess()) continue;
            commandOut.debug("Module " + module.getId() + " processing");
            this.createModuleElement(module);
            module.process();
        }
    }

    protected void createModuleElement(ExporterModule module) {
        Element moduleElement = this.indexRootElement.addElement(this.getIndexModuleElementName());
        moduleElement.addAttribute(this.getIndexModuleIdAttributeName(), module.getId());
        this.moduleIndexElements.put(module.getId(), moduleElement);
    }

    protected void writeIndexDocument(Document indexDocument) {
        OutputStream indexOut = this.getIndexOutput();
        boolean closeIndexOut = true;
        try {
            OutputFormat format = new OutputFormat();
            format.setEncoding(this.getCharacterEncoding());
            XMLWriter writer = new XMLWriter(indexOut, format);
            writer.write(indexDocument);
            closeIndexOut = false;
            indexOut.close();
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (closeIndexOut) {
                try {
                    indexOut.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing index output", (Throwable)e);
                }
            }
        }
    }

    protected OutputStream getIndexOutput() {
        try {
            return this.output.getFileOutputStream(this.getIndexFilename());
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected class ModuleContextImpl
    implements ExporterModuleContext {
        private final String moduleId;

        public ModuleContextImpl(String moduleId) {
            this.moduleId = moduleId;
        }

        @Override
        public String getCharacterEncoding() {
            return ExporterImpl.this.getCharacterEncoding();
        }

        @Override
        public ExportTask getExportTask() {
            return ExporterImpl.this.task;
        }

        @Override
        public Element getModuleIndexElement() {
            return ExporterImpl.this.getIndexModuleElement(this.moduleId);
        }
    }
}

