/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.export.modules.ExporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceDataProvider;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OlapUnitViewOptionsDataProvider
implements ResourceDataProvider {
    private static final Log log = LogFactory.getLog(OlapUnitViewOptionsDataProvider.class);
    private String filenameSuffix;

    @Override
    public String getFileName(Resource resource) {
        return resource.getName() + this.getFilenameSuffix();
    }

    @Override
    public InputStream getData(ExporterModuleContext exportContext, Resource resource) {
        BufferedInputStream dataStream;
        OlapUnit unit = (OlapUnit)resource;
        Object viewOptions = unit.getOlapViewOptions();
        if (viewOptions == null) {
            dataStream = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(baos));
            e.writeObject(unit.getOlapViewOptions());
            e.flush();
            e.close();
            dataStream = new BufferedInputStream(new ByteArrayInputStream(baos.toByteArray()));
        }
        return dataStream;
    }

    public String getFilenameSuffix() {
        return this.filenameSuffix;
    }

    public void setFilenameSuffix(String filenameSuffix) {
        this.filenameSuffix = filenameSuffix;
    }
}

