/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl;

import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportExecutionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.iterators.ReverseListIterator;

public class CompositeReportExecutionListener
implements ReportExecutionListener {
    private static final CompositeReportExecutionListener EMPTY = new CompositeReportExecutionListener(Collections.<ReportExecutionListener>emptyList());
    private final List<ReportExecutionListener> listeners;

    public static ReportExecutionListener asListener(List<ReportExecutionListener> listeners) {
        if (listeners == null || listeners.isEmpty()) {
            return EMPTY;
        }
        if (listeners.size() == 1) {
            return listeners.get(0);
        }
        return new CompositeReportExecutionListener(listeners);
    }

    public static ReportExecutionListener combine(ReportExecutionListener first, ReportExecutionListener second) {
        ReportExecutionListener combined;
        List<ReportExecutionListener> firstList = CompositeReportExecutionListener.list(first);
        List<ReportExecutionListener> secondList = CompositeReportExecutionListener.list(second);
        if (firstList.isEmpty()) {
            combined = secondList.isEmpty() ? EMPTY : second;
        } else if (secondList.isEmpty()) {
            combined = first;
        } else {
            ArrayList<ReportExecutionListener> list = new ArrayList<ReportExecutionListener>(firstList.size() + secondList.size());
            list.addAll(firstList);
            list.addAll(secondList);
            combined = new CompositeReportExecutionListener(list);
        }
        return combined;
    }

    private static List<ReportExecutionListener> list(ReportExecutionListener listener) {
        if (listener == null) {
            return Collections.emptyList();
        }
        if (listener instanceof CompositeReportExecutionListener) {
            return ((CompositeReportExecutionListener)listener).listeners;
        }
        return Collections.singletonList(listener);
    }

    public CompositeReportExecutionListener(List<ReportExecutionListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void init() {
        for (ReportExecutionListener listener : this.listeners) {
            listener.init();
        }
    }

    @Override
    public void start() {
        for (ReportExecutionListener listener : this.listeners) {
            listener.start();
        }
    }

    @Override
    public void end(boolean success) {
        ReverseListIterator it = new ReverseListIterator(this.listeners);
        while (it.hasNext()) {
            ReportExecutionListener listener = (ReportExecutionListener)it.next();
            listener.end(success);
        }
    }
}

