/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSAwsDataSourceRecoveryException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcDataSourceService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsDataSourceRecovery;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.AwsReportDataSource;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class AwsDataSourceService
extends JdbcDataSourceService {
    private static final Log log = LogFactory.getLog(AwsDataSourceService.class);
    public static final String SQL_STATE_CLASS = "08";
    private AwsReportDataSource awsReportDataSource;
    private AwsDataSourceRecovery awsDataSourceRecovery;

    public AwsDataSourceService(DataSource dataSource, TimeZone timezone, AwsReportDataSource awsReportDataSource, AwsDataSourceRecovery awsDataSourceRecovery) {
        super(dataSource, timezone);
        this.awsReportDataSource = awsReportDataSource;
        this.awsDataSourceRecovery = awsDataSourceRecovery;
    }

    @Override
    protected Connection createConnection() {
        try {
            return this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            throw new JSException(this.getErrorMessage("jsexception.error.creating.connection"), (Throwable)e);
        }
    }

    @Override
    public DataSource getDataSource() {
        return new AwsDataSourceWrapper(super.getDataSource());
    }

    private String getErrorMessage(String errorCode) {
        return this.awsDataSourceRecovery.getMessageSource().getMessage(errorCode, null, LocaleContextHolder.getLocale());
    }

    private class AwsDataSourceWrapper
    extends PoolingDataSource {
        private DataSource dataSource;

        AwsDataSourceWrapper(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Connection getConnection() throws SQLException {
            try {
                Connection c = this.dataSource.getConnection();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Create Connection successful at com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.AwsDataSourceService.createConnection");
                }
                return c;
            }
            catch (SQLException e) {
                Throwable throwable = ExceptionUtils.getRootCause((Throwable)e);
                if (throwable instanceof ConnectException || throwable instanceof SocketTimeoutException || e.getSQLState().startsWith(AwsDataSourceService.SQL_STATE_CLASS)) {
                    AwsDataSourceService.this.awsDataSourceRecovery.createAwsDSSecurityGroup(AwsDataSourceService.this.awsReportDataSource);
                    try {
                        return this.dataSource.getConnection();
                    }
                    catch (SQLException ex) {
                        throwable = ExceptionUtils.getRootCause((Throwable)e);
                        if (throwable instanceof ConnectException || throwable instanceof SocketTimeoutException || e.getSQLState().startsWith(AwsDataSourceService.SQL_STATE_CLASS)) {
                            throw new JSAwsDataSourceRecoveryException(e.getMessage() + "\n" + AwsDataSourceService.this.getErrorMessage("aws.exception.datasource.recovery.timeout"));
                        }
                        log.error((Object)"Error creating connection.", (Throwable)e);
                        throw new JSException(AwsDataSourceService.this.getErrorMessage("jsexception.error.creating.connection"), (Throwable)e);
                    }
                }
                log.error((Object)"Error creating connection.", (Throwable)e);
                throw new JSException(AwsDataSourceService.this.getErrorMessage("jsexception.error.creating.connection"), (Throwable)e);
            }
        }

        public boolean isWrapperFor(Class<?> aClass) throws SQLException {
            return this.dataSource.isWrapperFor(aClass);
        }

        public <T> T unwrap(Class<T> tClass) throws SQLException {
            return this.dataSource.unwrap(tClass);
        }
    }
}

