/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataCacheProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataSnapshotCachingService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataSnapshotPersistResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataSnapshotService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CopyDestinationExistsException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CopyDestinationNotReportException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.RepositoryUtils;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshot;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshotData;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotPersistenceService;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotPersistentMetadata;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotSavedId;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jasperreports.data.cache.DataSnapshot;
import net.sf.jasperreports.engine.ReportContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class StandardDataSnapshotService
implements DataSnapshotService {
    private static final Log log = LogFactory.getLog(StandardDataSnapshotService.class);
    private boolean snapshotRecordingEnabled;
    private boolean snapshotPersistenceEnabled;
    private DataSnapshotPersistenceService persistenceService;
    private DataSnapshotCachingService cachingService;
    private DataCacheProvider dataCacheProvider;
    private RepositoryService repository;
    private RepositoryService unsecureRepository;
    protected static final Pattern PATTERN_RESOURCE_NAME_REPLACE = Pattern.compile("[^\\p{L}\\p{N}_.-]");

    @Override
    public DataSnapshotPersistentMetadata getSnapshotMetadata(ExecutionContext context, long snapshotId) {
        DataSnapshotPersistentMetadata metadata = this.cachingService.getSnapshotMetadata(context, snapshotId);
        if (metadata == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("no cached snapshot " + snapshotId));
            }
        } else {
            int cachedVersion = metadata.getVersion();
            if (this.persistenceService.matchesVersion(context, snapshotId, cachedVersion)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found cached snapshot " + snapshotId + " at version " + cachedVersion));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("invalidating cached snapshot " + snapshotId + " with version " + cachedVersion));
                }
                this.cachingService.invalidateSnapshot(context, snapshotId);
                metadata = null;
            }
        }
        if (metadata == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading data snapshot metadata " + snapshotId));
            }
            if ((metadata = this.persistenceService.loadDataSnapshotMetadata(context, snapshotId)) == null) {
                log.info((Object)("saved data snapshot metadata " + snapshotId + " not found"));
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("loaded snapshot metadata " + snapshotId + " at version " + metadata.getVersion()));
            }
            this.cachingService.putSnapshotMetadata(context, snapshotId, metadata);
        }
        return metadata;
    }

    @Override
    public DataSnapshot getSnapshotContents(ExecutionContext context, long contentsId) {
        DataSnapshot snapshotContents = this.cachingService.getSnapshotContents(context, contentsId);
        if (snapshotContents == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading data snapshot contents " + contentsId));
            }
            if ((snapshotContents = this.persistenceService.loadDataSnapshot(context, contentsId)) == null) {
                log.info((Object)("saved data snapshot contents " + contentsId + " not found"));
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("loaded data snapshot contents " + contentsId));
            }
            this.cachingService.putSnapshotContents(context, contentsId, snapshotContents);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("found cached snapshot contents " + contentsId));
        }
        return snapshotContents;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public long saveDataSnapshot(ExecutionContext context, DataCacheSnapshot snapshot, Long existingSnapshotId) {
        DataSnapshotSavedId saved = this.persistenceService.saveDataSnapshot(context, snapshot, existingSnapshotId);
        this.cachingService.put(context, saved, snapshot);
        return saved.getSnapshotId();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void deleteSnapshot(ExecutionContext context, long snapshotId) {
        this.persistenceService.deleteSnapshot(snapshotId);
        this.cachingService.invalidateSnapshot(context, snapshotId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public boolean saveAutoReportDataSnapshot(ExecutionContext context, ReportContext reportContext, ReportUnit reportUnit) {
        DataCacheProvider.SnapshotSaveStatus saveStatus = this.dataCacheProvider.getSnapshotSaveStatus(reportContext);
        if (saveStatus != DataCacheProvider.SnapshotSaveStatus.NEW) {
            throw new JSException("Data snapshot is not new");
        }
        ReportUnit repositoryRU = this.loadRepositoryReportUnit(context, reportUnit);
        boolean dirtyReportUnit = this.applyReportUnitChanges(context, reportContext, repositoryRU, false, reportUnit.getURIString());
        if (!dirtyReportUnit) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("saving report unit " + repositoryRU.getPath()));
        }
        this.getUnsecureRepository().saveResource(context, (Resource)repositoryRU);
        return true;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public boolean saveReportDataSnapshot(ExecutionContext context, ReportContext reportContext, ReportUnit reportUnit) {
        ReportUnit repositoryRU = this.loadRepositoryReportUnit(context, reportUnit);
        boolean dirtyReportUnit = this.applyReportUnitChanges(context, reportContext, repositoryRU, false, reportUnit.getURIString());
        if (!dirtyReportUnit) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("saving report unit " + repositoryRU.getPath()));
        }
        this.getRepository().saveResource(context, (Resource)repositoryRU);
        return true;
    }

    protected boolean applyReportUnitChanges(ExecutionContext context, ReportContext reportContext, ReportUnit reportUnit, boolean copyDataSnapshot, String originalReportUri) {
        boolean dirtyReportUnit = false;
        Long currentSnapshotId = reportUnit.getDataSnapshotId();
        Long existingSnapshotId = copyDataSnapshot ? null : reportUnit.getDataSnapshotId();
        DataSnapshotPersistResult result = this.persistDataSnapshot(context, reportContext, existingSnapshotId);
        Long savedSnapshotId = result.getSavedSnapshotId();
        if (currentSnapshotId == null ? savedSnapshotId != null : savedSnapshotId == null || !currentSnapshotId.equals(savedSnapshotId)) {
            reportUnit.setDataSnapshotId(savedSnapshotId);
            dirtyReportUnit = true;
        }
        return dirtyReportUnit;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public DataSnapshotPersistResult persistDataSnapshot(ExecutionContext context, ReportContext reportContext, Long existingSnapshotId) {
        boolean changed;
        Long savedSnapshotId;
        DataCacheSnapshot snapshot = this.dataCacheProvider.getDataSnapshot(context, reportContext);
        if (!this.isSnapshotPersistenceEnabled() || snapshot != null && !snapshot.getSnapshot().isPersistable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"data snapshot not persistable");
            }
            snapshot = null;
        }
        if (snapshot == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"no data snapshot to save");
            }
            savedSnapshotId = null;
            if (existingSnapshotId == null) {
                changed = false;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("deleting data snapshot " + existingSnapshotId));
                }
                this.deleteSnapshot(context, existingSnapshotId);
                changed = true;
            }
        } else if (snapshot.isSaved() && existingSnapshotId != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("snapshot " + existingSnapshotId + " has not changed"));
            }
            savedSnapshotId = existingSnapshotId;
            changed = false;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("saving data snapshot with current id " + existingSnapshotId));
            }
            savedSnapshotId = this.saveDataSnapshot(context, snapshot, existingSnapshotId);
            changed = true;
            this.dataCacheProvider.snapshotSaved(context, reportContext, snapshot, savedSnapshotId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("saved data snapshot " + savedSnapshotId));
            }
        }
        return new DataSnapshotPersistResult(changed, savedSnapshotId);
    }

    protected ReportUnit loadRepositoryReportUnit(ExecutionContext context, ReportUnit reportUnit) {
        ReportUnit repositoryRU = (ReportUnit)this.getRepository().getResource(context, reportUnit.getURIString(), ReportUnit.class);
        if (repositoryRU == null) {
            throw new JSException("Report unit not found at " + reportUnit.getURIString());
        }
        if (repositoryRU.getVersion() != reportUnit.getVersion()) {
            throw new JSException("Report unit has been modified after it was loaded");
        }
        return repositoryRU;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public String saveReportDataSnapshotCopy(ExecutionContext context, ReportContext reportContext, ReportUnit reportUnit, String folderUri, String label, boolean overwrite) throws CopyDestinationExistsException {
        ReportUnit reportUnitCopy;
        String copyName = this.makeResourceName(label);
        String copyURI = RepositoryUtils.concatenatePath((String)folderUri, (String)copyName);
        FilterCriteria criteria = FilterCriteria.createFilter();
        criteria.addFilterElement((FilterElement)FilterCriteria.createResourceURIFilter((String)copyURI));
        List resources = this.getRepository().loadResourcesList(context, criteria);
        if (resources != null && !resources.isEmpty()) {
            ResourceLookup resource = (ResourceLookup)resources.get(0);
            if (!ReportUnit.class.getName().equals(resource.getResourceType())) {
                throw new CopyDestinationNotReportException(copyURI);
            }
            if (!overwrite) {
                throw new CopyDestinationExistsException(copyURI);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("deleting existing resource " + copyURI));
            }
            this.getRepository().deleteResource(context, copyURI);
        }
        if ((reportUnitCopy = (ReportUnit)this.getRepository().makeResourceCopy(context, reportUnit.getURIString(), reportUnit.getVersion(), ReportUnit.class, copyURI)) == null) {
            throw new JSException("Report unit not found at " + reportUnit.getURIString());
        }
        reportUnitCopy.setLabel(label);
        this.applyReportUnitChanges(context, reportContext, reportUnitCopy, true, reportUnit.getURIString());
        if (log.isDebugEnabled()) {
            log.debug((Object)("saving report unit copy of " + reportUnit.getURIString() + " at " + copyURI));
        }
        this.getRepository().saveResource(context, (Resource)reportUnitCopy);
        return copyURI;
    }

    protected String makeResourceName(String label) {
        return PATTERN_RESOURCE_NAME_REPLACE.matcher(label).replaceAll("_");
    }

    @Override
    public DataCacheSnapshotData loadSnapshotData(ExecutionContext context, Long snapshotId) {
        return this.persistenceService.loadSnapshotData(context, snapshotId.longValue());
    }

    @Override
    public long saveDataSnapshot(ExecutionContext context, DataCacheSnapshotData dataSnapshot) {
        return this.persistenceService.saveDataSnapshot(context, dataSnapshot);
    }

    @Override
    public Long copyDataSnapshot(Long snapshotId) {
        return this.persistenceService.copyDataSnapshot(snapshotId.longValue());
    }

    public DataSnapshotPersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(DataSnapshotPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public DataSnapshotCachingService getCachingService() {
        return this.cachingService;
    }

    public void setCachingService(DataSnapshotCachingService cachingService) {
        this.cachingService = cachingService;
    }

    public DataCacheProvider getDataCacheProvider() {
        return this.dataCacheProvider;
    }

    public void setDataCacheProvider(DataCacheProvider dataCacheProvider) {
        this.dataCacheProvider = dataCacheProvider;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public RepositoryService getUnsecureRepository() {
        return this.unsecureRepository;
    }

    public void setUnsecureRepository(RepositoryService unsecureRepository) {
        this.unsecureRepository = unsecureRepository;
    }

    @Override
    public boolean isSnapshotRecordingEnabled() {
        return this.snapshotRecordingEnabled;
    }

    public void setSnapshotRecordingEnabled(boolean snapshotRecordingEnabled) {
        this.snapshotRecordingEnabled = snapshotRecordingEnabled;
    }

    @Override
    public boolean isSnapshotPersistenceEnabled() {
        return this.snapshotPersistenceEnabled;
    }

    public void setSnapshotPersistenceEnabled(boolean snapshotPersistenceEnabled) {
        this.snapshotPersistenceEnabled = snapshotPersistenceEnabled;
    }
}

