/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceBundleHelper {
    public static final String BUNDLE_FILE_EXTENSION = ".properties";
    private static Pattern PATTERN_BUNDLE_FILE = Pattern.compile(".*(?:(?:[_])([a-z][a-z]))(?:[_]){0,1}([A-Z][A-Z]){0,1}(?:(?:[_])([^_]*)){0,1}\\.properties");

    public static Locale parseSuffixForLocale(String fileName) {
        Matcher m = PATTERN_BUNDLE_FILE.matcher(fileName);
        if (m.find()) {
            String language = m.group(1);
            String country = m.group(2) != null ? m.group(2) : "";
            String variant = m.group(3) != null ? m.group(3) : "";
            return new Locale(language, country, variant);
        }
        return new Locale("", "", "");
    }

    public static String getBaseName(String fileName) {
        Locale locale = ResourceBundleHelper.parseSuffixForLocale(fileName);
        String localeStr = locale.toString();
        String searchStr = localeStr.length() > 0 ? "_" + localeStr : "";
        int k = fileName.indexOf(searchStr + BUNDLE_FILE_EXTENSION);
        if (k > 0) {
            return fileName.substring(0, k);
        }
        return "";
    }

    public static boolean isBundle(String fileName) {
        return fileName.endsWith(BUNDLE_FILE_EXTENSION);
    }
}

