/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.JSSchedulerFactory;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.LocalThreadExecutor;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.NullTaskExecutor;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.NullThreadExecutor;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.spi.ThreadExecutor;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class JSSchedulerFactoryBean
extends SchedulerFactoryBean {
    private static final Log log = LogFactory.getLog(JSSchedulerFactoryBean.class);
    private ThreadExecutor ThreadExecutor;

    public JSSchedulerFactoryBean() {
        this.setSchedulerFactoryClass(JSSchedulerFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Scheduler createScheduler(SchedulerFactory schedulerFactory, String schedulerName) throws SchedulerException {
        try {
            if (this.ThreadExecutor != null) {
                if (!(schedulerFactory instanceof JSSchedulerFactory)) {
                    throw new RuntimeException("A JSSchedulerFactory scheduler factory is required");
                }
                LocalThreadExecutor.setLocalThreadExecutor(this.ThreadExecutor);
                JSSchedulerFactory factory = (JSSchedulerFactory)schedulerFactory;
                factory.getInitProps().setProperty("org.quartz.threadExecutor.class", LocalThreadExecutor.class.getName());
                factory.reinit();
            }
            Scheduler scheduler = super.createScheduler(schedulerFactory, schedulerName);
            return scheduler;
        }
        finally {
            if (this.ThreadExecutor != null) {
                LocalThreadExecutor.setLocalThreadExecutor(null);
            }
        }
    }

    public ThreadExecutor getThreadExecutor() {
        return this.ThreadExecutor;
    }

    public void setThreadExecutor(ThreadExecutor ThreadExecutor2) {
        if (ThreadExecutor2 instanceof NullThreadExecutor) {
            ThreadExecutor2 = null;
        }
        this.ThreadExecutor = ThreadExecutor2;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        if (taskExecutor instanceof NullTaskExecutor) {
            taskExecutor = null;
        }
        super.setTaskExecutor(taskExecutor);
    }
}

