/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.util.FTPService;
import com.jaspersoft.jasperserver.api.engine.common.util.impl.FTPUtil;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.FTPInfo;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJobFileSaving;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportOutput;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockHandle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.util.IOUtils;

public class ReportExecutionJobFileSavingImpl
implements ReportExecutionJobFileSaving {
    private static final Log log = LogFactory.getLog(ReportExecutionJobFileSavingImpl.class);
    protected static final String LOCK_NAME_CONTENT_RESOURCE = "reportSchedulerOutput";
    private FTPService ftpService = new FTPUtil();
    private boolean enableSaveToHostFS;

    public FTPService getFtpService() {
        return this.ftpService;
    }

    public void setFtpService(FTPService ftpService) {
        this.ftpService = ftpService;
    }

    @Override
    public void save(ReportExecutionJob job, ReportOutput output, boolean useFolderHierarchy, ReportJob jobDetails) {
        if (jobDetails.getContentRepositoryDestination() == null) {
            return;
        }
        try {
            this.saveToRepository(job, output, jobDetails);
        }
        catch (Exception e) {
            job.handleException(job.getMessage("report.scheduling.error.saving.to.repository", new Object[]{output.getFilename()}), e);
        }
        if (!this.isSaveToDisk(jobDetails) && !this.isSaveToFTPServer(jobDetails)) {
            return;
        }
        Map<String, byte[]> zipOutput = null;
        try {
            zipOutput = this.zipFile(job, output, useFolderHierarchy);
        }
        catch (Exception e) {
            job.handleException(job.getMessage("report.scheduling.error.creating.zip.output", new Object[]{output.getFilename()}), e);
        }
        for (Map.Entry<String, byte[]> entry : zipOutput.entrySet()) {
            try {
                if (this.isEnableSaveToHostFS()) {
                    this.saveToDisk(job, entry.getKey(), entry.getValue(), jobDetails);
                } else {
                    log.debug((Object)("skipped saveToDisk since isEnableSaveToHostFS=" + this.isEnableSaveToHostFS()));
                }
            }
            catch (Exception e) {
                job.handleException(job.getMessage("report.scheduling.error.writing.to.disk", new Object[]{output.getFilename()}), e);
            }
            try {
                this.saveToFTPServer(job, entry.getKey(), entry.getValue(), jobDetails);
            }
            catch (Exception e) {
                job.handleException(job.getMessage("report.scheduling.error.updating.to.server", new Object[]{output.getFilename()}), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveToRepository(ReportExecutionJob job, ReportOutput output, ReportJob jobDetails) {
        RepositoryService repositoryService = job.getRepository();
        ReportJobRepositoryDestination repositoryDestination = jobDetails.getContentRepositoryDestination();
        if (!repositoryDestination.isSaveToRepository()) {
            return;
        }
        List children = output.getChildren();
        ArrayList<ContentResource> childResources = new ArrayList<ContentResource>(children.size());
        for (ReportOutput childOutput : children) {
            ContentResource childRes = (ContentResource)repositoryService.newResource(job.executionContext, ContentResource.class);
            childRes.setName(childOutput.getFilename());
            childRes.setLabel(childOutput.getFilename());
            childRes.setFileType(childOutput.getFileType());
            childRes.setDataContainer(childOutput.getPersistenceData());
            childResources.add(childRes);
        }
        ContentResource contentRes = null;
        String folderURI = null;
        folderURI = repositoryDestination.isUsingDefaultReportOutputFolderURI() && repositoryDestination.getDefaultReportOutputFolderURI() != null ? repositoryDestination.getDefaultReportOutputFolderURI() : repositoryDestination.getFolderURI();
        String resURI = folderURI + "/" + output.getFilename();
        LockHandle lock = this.lockOutputResource(job, resURI);
        try {
            Resource existingRes = repositoryService.getResource(job.executionContext, resURI);
            if (repositoryDestination.isOverwriteFiles()) {
                if (existingRes != null) {
                    if (!(existingRes instanceof ContentResource)) {
                        String quotedResURI = "\"" + resURI + "\"";
                        throw new JSException("jsexception.report.no.content.resource", new Object[]{quotedResURI});
                    }
                    contentRes = (ContentResource)existingRes;
                }
            } else if (existingRes != null) {
                throw new JSException("jsexception.report.resource.already.exists.no.overwrite", new Object[]{resURI});
            }
            if (contentRes == null) {
                contentRes = (ContentResource)repositoryService.newResource(job.executionContext, ContentResource.class);
                contentRes.setName(output.getFilename());
                contentRes.setLabel(output.getFilename());
                contentRes.setDescription(jobDetails.getContentRepositoryDestination().getOutputDescription());
                contentRes.setParentFolder(repositoryDestination.getFolderURI());
            }
            contentRes.setFileType(output.getFileType());
            contentRes.setDataContainer(output.getPersistenceData());
            contentRes.setResources(childResources);
            if (job.executionContext.getAttributes() == null) {
                job.executionContext.setAttributes(new ArrayList());
            }
            job.executionContext.getAttributes().add("isOverwriting");
            repositoryService.saveResource(job.executionContext, (Resource)contentRes);
            output.setRepositoryPath(resURI);
        }
        finally {
            this.unlock(job, lock);
        }
    }

    protected boolean isSaveToDisk(ReportJob jobDetails) {
        ReportJobRepositoryDestination repositoryDestination = jobDetails.getContentRepositoryDestination();
        return repositoryDestination != null && repositoryDestination.getOutputLocalFolder() != null;
    }

    protected void saveToDisk(ReportExecutionJob job, String fileName, byte[] data, ReportJob jobDetails) {
        if (!this.isSaveToDisk(jobDetails)) {
            return;
        }
        ReportJobRepositoryDestination repositoryDestination = jobDetails.getContentRepositoryDestination();
        String path = repositoryDestination.getOutputLocalFolder() + File.separator + fileName;
        try {
            if (!repositoryDestination.isOverwriteFiles() && new File(path).exists()) {
                throw new JSException("jsexception.report.resource.already.exists.no.overwrite", new Object[]{path});
            }
            File dirFile = new File(repositoryDestination.getOutputLocalFolder());
            if (!dirFile.exists()) {
                throw new JSException("jsexception.report.resource.output.local.folder.does.not.exist", new Object[]{repositoryDestination.getOutputLocalFolder()});
            }
            FileOutputStream outputStream = new FileOutputStream(path, false);
            this.copy(data, outputStream);
        }
        catch (IOException ex) {
            job.handleException(job.getMessage("report.scheduling.error.exporting.report.to.disk", new Object[]{path}), ex);
        }
    }

    protected boolean isSaveToFTPServer(ReportJob jobDetails) {
        ReportJobRepositoryDestination repositoryDestination = jobDetails.getContentRepositoryDestination();
        return repositoryDestination != null && repositoryDestination.getOutputFTPInfo() != null && repositoryDestination.getOutputFTPInfo().getServerName() != null;
    }

    protected void saveToFTPServer(ReportExecutionJob job, String fileName, byte[] data, ReportJob jobDetails) {
        if (!this.isSaveToFTPServer(jobDetails)) {
            return;
        }
        FTPInfo ftpInfo = jobDetails.getContentRepositoryDestination().getOutputFTPInfo();
        try {
            FTPService.FTPServiceClient ftpServiceClient = null;
            ftpServiceClient = ftpInfo.getType().equals(FTPInfo.TYPE_FTP) ? this.ftpService.connectFTP(ftpInfo.getServerName(), ftpInfo.getPort(), ftpInfo.getUserName(), ftpInfo.getPassword()) : this.ftpService.connectFTPS(ftpInfo.getServerName(), ftpInfo.getPort(), ftpInfo.getProtocol(), ftpInfo.isImplicit(), ftpInfo.getPbsz(), ftpInfo.getProt(), ftpInfo.getUserName(), ftpInfo.getPassword());
            ftpServiceClient.changeDirectory(ftpInfo.getFolderPath());
            if (!jobDetails.getContentRepositoryDestination().isOverwriteFiles() && ftpServiceClient.exists(fileName)) {
                throw new JSException("jsexception.report.resource.already.exists.no.overwrite", new Object[]{ftpInfo.getServerName() + ftpInfo.getFolderPath() + "/" + fileName});
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            ftpServiceClient.putFile(fileName, (InputStream)inputStream);
            ftpServiceClient.disconnect();
        }
        catch (Exception ex) {
            job.handleException(job.getMessage("report.scheduling.error.upload.to.ftp.server", new Object[]{ftpInfo.getServerName() + ftpInfo.getFolderPath() + "/" + fileName}), ex);
        }
    }

    protected String getChildrenFolderName(ReportExecutionJob job, String resourceName) {
        return job.getRepository().getChildrenFolderName(resourceName);
    }

    protected LockHandle lockOutputResource(ReportExecutionJob job, String uri) {
        return job.getLockManager().lock(LOCK_NAME_CONTENT_RESOURCE, uri);
    }

    protected void unlock(ReportExecutionJob job, LockHandle lock) {
        job.getLockManager().unlock(lock);
    }

    private void copy(byte[] data, FileOutputStream os) throws IOException {
        os.write(data);
        os.flush();
        os.close();
    }

    private Map<String, byte[]> zipFile(ReportExecutionJob job, ReportOutput output, boolean useFolderHierarchy) throws IOException {
        DataContainer attachmentData;
        String attachmentName;
        if (output.getChildren().isEmpty()) {
            attachmentName = output.getFilename();
            attachmentData = output.getData();
        } else {
            attachmentData = job.createDataContainer();
            boolean close = true;
            ZipOutputStream zipOut = new ZipOutputStream(attachmentData.getOutputStream());
            try {
                zipOut.putNextEntry(new ZipEntry(output.getFilename()));
                DataContainerStreamUtil.pipeDataAndCloseInput((InputStream)output.getData().getInputStream(), (OutputStream)zipOut);
                zipOut.closeEntry();
                for (ReportOutput child : output.getChildren()) {
                    String childName = child.getFilename();
                    if (useFolderHierarchy) {
                        childName = this.getChildrenFolderName(job, output.getFilename()) + '/' + childName;
                    }
                    zipOut.putNextEntry(new ZipEntry(childName));
                    DataContainerStreamUtil.pipeDataAndCloseInput((InputStream)child.getData().getInputStream(), (OutputStream)zipOut);
                    zipOut.closeEntry();
                }
                zipOut.finish();
                zipOut.flush();
                close = false;
                zipOut.close();
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        zipOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
            attachmentName = output.getFilename() + ".zip";
        }
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        result.put(attachmentName, IOUtils.toByteArray((InputStream)attachmentData.getInputStream()));
        return result;
    }

    public boolean isEnableSaveToHostFS() {
        return this.enableSaveToHostFS;
    }

    public void setEnableSaveToHostFS(boolean enableSaveToHostFS) {
        this.enableSaveToHostFS = enableSaveToHostFS;
    }
}

