/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.Authentication;
import org.springframework.security.ui.TargetUrlResolver;
import org.springframework.security.ui.savedrequest.SavedRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TargetUrlResolverImpl
implements TargetUrlResolver {
    public static String DEFAULT_TARGET_PARAMETER = "spring-security-redirect";
    private String targetUrlParameter = DEFAULT_TARGET_PARAMETER;
    private boolean justUseSavedRequestOnGet = false;

    public String determineTargetUrl(SavedRequest savedRequest, HttpServletRequest currentRequest, Authentication auth) {
        String targetUrl = currentRequest.getParameter(this.targetUrlParameter);
        if (StringUtils.hasText((String)targetUrl)) {
            try {
                return URLDecoder.decode(targetUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 not supported. Shouldn't be possible");
            }
        }
        if (savedRequest != null && (!this.justUseSavedRequestOnGet || savedRequest.getMethod().equals("GET"))) {
            targetUrl = savedRequest.getFullRequestUrl();
        }
        return targetUrl;
    }

    protected boolean isJustUseSavedRequestOnGet() {
        return this.justUseSavedRequestOnGet;
    }

    public void setJustUseSavedRequestOnGet(boolean justUseSavedRequestOnGet) {
        this.justUseSavedRequestOnGet = justUseSavedRequestOnGet;
    }

    public void setTargetUrlParameter(String targetUrlParameter) {
        Assert.hasText((String)"targetUrlParameter cannot be null or empty");
        this.targetUrlParameter = targetUrlParameter;
    }
}

