/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.packet;

import java.io.IOException;
import org.mariadb.jdbc.internal.common.ColumnInformation;
import org.mariadb.jdbc.internal.common.PacketFetcher;
import org.mariadb.jdbc.internal.common.ValueObject;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;
import org.mariadb.jdbc.internal.mysql.MySQLValueObject;

public class MySQLRowPacket {
    private final ValueObject[] columns;
    private final Reader reader;
    private final ColumnInformation[] columnInformation;

    public MySQLRowPacket(RawPacket rawPacket, ColumnInformation[] columnInformation2) throws IOException {
        this.columns = new ValueObject[columnInformation2.length];
        this.reader = new Reader(rawPacket);
        this.columnInformation = columnInformation2;
    }

    public boolean isPacketComplete() throws IOException {
        long remaining;
        long encLength = this.reader.getSilentLengthEncodedBinary();
        return encLength <= (remaining = (long)this.reader.getRemainingSize());
    }

    public void appendPacket(RawPacket rawPacket) {
        this.reader.appendPacket(rawPacket);
    }

    public ValueObject[] getRow(PacketFetcher packetFetcher) throws IOException {
        for (int i = 0; i < this.columnInformation.length; ++i) {
            while (!this.isPacketComplete()) {
                this.appendPacket(packetFetcher.getRawPacket());
            }
            this.columns[i] = new MySQLValueObject(this.reader.getLengthEncodedBytes(), this.columnInformation[i]);
        }
        return this.columns;
    }
}

