/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.connection;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="ftp")
public class FtpConnection {
    private String host;
    private String userName;
    private String password;
    private String folderPath;
    private FtpType type;
    private String protocol;
    private Integer port;
    private Boolean implicit;
    private String prot;
    private Long pbsz;

    public FtpConnection() {
    }

    public FtpConnection(FtpConnection source) {
        this.host = source.getHost();
        this.userName = source.getUserName();
        this.password = source.getPassword();
        this.folderPath = source.getFolderPath();
        this.type = source.getType();
        this.protocol = source.getProtocol();
        this.port = source.getPort();
        this.implicit = source.getImplicit();
        this.prot = source.getProt();
        this.pbsz = source.getPbsz();
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public FtpConnection setFolderPath(String folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public FtpType getType() {
        return this.type;
    }

    public FtpConnection setType(FtpType type) {
        this.type = type;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public FtpConnection setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public FtpConnection setPort(Integer port) {
        this.port = port;
        return this;
    }

    public Boolean getImplicit() {
        return this.implicit;
    }

    public FtpConnection setImplicit(Boolean implicit) {
        this.implicit = implicit;
        return this;
    }

    public String getProt() {
        return this.prot;
    }

    public FtpConnection setProt(String prot) {
        this.prot = prot;
        return this;
    }

    public Long getPbsz() {
        return this.pbsz;
    }

    public FtpConnection setPbsz(Long pbsz) {
        this.pbsz = pbsz;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public FtpConnection setHost(String host) {
        this.host = host;
        return this;
    }

    public String getUserName() {
        String ret = this.userName != null && !this.userName.isEmpty() ? this.userName : "anonymous";
        return ret;
    }

    public FtpConnection setUserName(String userName) {
        this.userName = userName != null && !userName.isEmpty() ? userName : "anonymous";
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public FtpConnection setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FtpConnection that = (FtpConnection)o;
        if (this.folderPath != null ? !this.folderPath.equals(that.folderPath) : that.folderPath != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.implicit != null ? !this.implicit.equals(that.implicit) : that.implicit != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.pbsz != null ? !this.pbsz.equals(that.pbsz) : that.pbsz != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.prot != null ? !this.prot.equals(that.prot) : that.prot != null) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(that.userName) : that.userName != null);
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.folderPath != null ? this.folderPath.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.implicit != null ? this.implicit.hashCode() : 0);
        result = 31 * result + (this.prot != null ? this.prot.hashCode() : 0);
        result = 31 * result + (this.pbsz != null ? this.pbsz.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FtpConnection{host='" + this.host + '\'' + ", userName='" + this.userName + '\'' + ", password='" + this.password + '\'' + ", folderPath='" + this.folderPath + '\'' + ", type=" + (Object)((Object)this.type) + ", protocol='" + this.protocol + '\'' + ", port=" + this.port + ", implicit=" + this.implicit + ", prot='" + this.prot + '\'' + ", pbsz=" + this.pbsz + "} " + super.toString();
    }

    public static enum FtpType {
        ftp,
        ftps;

    }
}

