/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate;

import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ResourceLookupImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.RepositoryLabelIDHelper;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import java.util.List;

public class HibernateUtil {
    private RepositoryService repo;

    public HibernateUtil(RepositoryService repository) {
        this.repo = repository;
    }

    public RepositoryService getRepo() {
        return this.repo;
    }

    public void setRepo(RepositoryService repo) {
        this.repo = repo;
    }

    public boolean resourceDisplayNameExists(String parentUri, String name, String displayName) {
        FilterCriteria criteria = FilterCriteria.createFilter();
        criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)(parentUri.startsWith("repo:") ? parentUri.substring(5) : parentUri)));
        List resources = this.repo.loadResourcesList(null, criteria);
        for (int i = 0; i < resources.size(); ++i) {
            ResourceLookupImpl res = (ResourceLookupImpl)resources.get(i);
            if (!res.getLabel().equalsIgnoreCase(displayName) || res.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean folderDisplayNameExists(String parentUri, String displayName) {
        List repoFolderList = this.repo.getSubFolders(null, parentUri.startsWith("repo:") ? parentUri.substring(5) : parentUri);
        for (int i = 0; i < repoFolderList.size(); ++i) {
            FolderImpl repoFolder = (FolderImpl)repoFolderList.get(i);
            if (!displayName.equalsIgnoreCase(repoFolder.getLabel())) continue;
            return true;
        }
        return false;
    }

    public boolean doesDisplayNameExist(String parentFolderUri, String name, String displayName) {
        return this.resourceDisplayNameExists(parentFolderUri, name, displayName) || this.folderDisplayNameExists(parentFolderUri, displayName);
    }

    public String generateUniqueID(String parentFolderUri, String displayName) {
        return RepositoryLabelIDHelper.generateIdBasedOnLabel(this.repo, parentFolderUri, displayName);
    }
}

