/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.data.snapshot.hibernate;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshot;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshotData;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshotMetadata;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotContentsPersistenceService;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotPersistenceService;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotPersistentMetadata;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotSavedId;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DefaultDataCacheSnapshotMetadata;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DefaultDataSnapshotPersistentMetadata;
import com.jaspersoft.jasperserver.api.metadata.data.snapshot.hibernate.PersistentDataSnapshot;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.data.cache.DataSnapshot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class HibernateDataSnapshotService
extends HibernateDaoImpl
implements DataSnapshotPersistenceService {
    private static final Log log = LogFactory.getLog(HibernateDataSnapshotService.class);
    private DataSnapshotContentsPersistenceService contentsPersistenceService;

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true)
    public boolean matchesVersion(ExecutionContext context, final long snapshotId, final int version) {
        return (Boolean)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Boolean>(){

            public Boolean doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = session.createCriteria(PersistentDataSnapshot.class);
                criteria.add(Restrictions.idEq((Object)snapshotId));
                criteria.add((Criterion)Restrictions.eq((String)"version", (Object)version));
                criteria.setProjection(Projections.rowCount());
                Number count = (Number)criteria.uniqueResult();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("version check for " + snapshotId + " and " + version + " returned " + count));
                }
                return count.intValue() > 0;
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true)
    public DataSnapshotPersistentMetadata loadDataSnapshotMetadata(ExecutionContext context, long snapshotId) {
        PersistentDataSnapshot persistentSnapshot = (PersistentDataSnapshot)this.getHibernateTemplate().get(PersistentDataSnapshot.class, (Serializable)Long.valueOf(snapshotId));
        if (persistentSnapshot == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("didn't find snapshot " + snapshotId));
            }
            return null;
        }
        DataSnapshotPersistentMetadata snapshotMeta = this.createSnapshotPersistentMetadata(persistentSnapshot);
        return snapshotMeta;
    }

    protected DataSnapshotPersistentMetadata createSnapshotPersistentMetadata(PersistentDataSnapshot persistentSnapshot) {
        DataCacheSnapshotMetadata metadata = this.createSnapshotMetadata(persistentSnapshot);
        DefaultDataSnapshotPersistentMetadata persistentMetadata = new DefaultDataSnapshotPersistentMetadata();
        persistentMetadata.setSnapshotMetadata(metadata);
        persistentMetadata.setVersion(persistentSnapshot.getVersion());
        persistentMetadata.setContentsId(persistentSnapshot.getContentsId());
        return persistentMetadata;
    }

    protected DataCacheSnapshotMetadata createSnapshotMetadata(PersistentDataSnapshot persistentSnapshot) {
        Map<String, Object> paramsCopy = this.copyParams(persistentSnapshot.getDataParameters());
        DefaultDataCacheSnapshotMetadata snapshotMeta = new DefaultDataCacheSnapshotMetadata(paramsCopy, persistentSnapshot.getSnapshotDate());
        return snapshotMeta;
    }

    protected Map<String, Object> copyParams(Map<String, Object> params) {
        return params == null ? new HashMap<String, Object>() : new HashMap<String, Object>(params);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true)
    public DataSnapshot loadDataSnapshot(ExecutionContext context, long contentsId) {
        return this.contentsPersistenceService.loadDataSnapshot(context, contentsId);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true)
    public DataCacheSnapshotData loadSnapshotData(ExecutionContext context, long snapshotId) {
        PersistentDataSnapshot persistentSnapshot = (PersistentDataSnapshot)this.getHibernateTemplate().get(PersistentDataSnapshot.class, (Serializable)Long.valueOf(snapshotId));
        if (persistentSnapshot == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("didn't find snapshot " + snapshotId));
            }
            return null;
        }
        DataCacheSnapshotMetadata snapshotMeta = this.createSnapshotMetadata(persistentSnapshot);
        DataContainer snapshotData = this.contentsPersistenceService.loadDataSnapshotData(context, persistentSnapshot.getContentsId());
        if (snapshotData == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("didn't find snapshot data " + persistentSnapshot.getContentsId()));
            }
            return null;
        }
        DataCacheSnapshotData snapshot = new DataCacheSnapshotData();
        snapshot.setMetadata(snapshotMeta);
        snapshot.setSnapshotData(snapshotData);
        return snapshot;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public DataSnapshotSavedId saveDataSnapshot(final ExecutionContext context, final DataCacheSnapshot snapshot, final Long existingSnapshotId) {
        return (DataSnapshotSavedId)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<DataSnapshotSavedId>(){

            public DataSnapshotSavedId doInHibernate(Session session) throws HibernateException, SQLException {
                PersistentDataSnapshot persistentSnapshot = null;
                if (existingSnapshotId != null && (persistentSnapshot = (PersistentDataSnapshot)HibernateDataSnapshotService.this.getHibernateTemplate().get(PersistentDataSnapshot.class, (Serializable)existingSnapshotId)) == null) {
                    log.info((Object)("Did not find snapshot " + existingSnapshotId + ", saving as new"));
                }
                boolean isNew = false;
                if (persistentSnapshot == null) {
                    persistentSnapshot = new PersistentDataSnapshot();
                    isNew = true;
                }
                if (!isNew) {
                    long currentContentsId = persistentSnapshot.getContentsId();
                    HibernateDataSnapshotService.this.contentsPersistenceService.deleteDataSnapshot(context, currentContentsId);
                }
                long contentsId = HibernateDataSnapshotService.this.contentsPersistenceService.saveDataSnapshot(context, snapshot.getSnapshot());
                persistentSnapshot.setContentsId(contentsId);
                DataCacheSnapshotMetadata snapshotMeta = snapshot.getMetadata();
                persistentSnapshot.setSnapshotDate(snapshotMeta.getSnapshotDate());
                Map<String, Object> paramsCopy = HibernateDataSnapshotService.this.copyParams(snapshotMeta.getParameters());
                persistentSnapshot.setDataParameters(paramsCopy);
                if (isNew) {
                    session.save((Object)persistentSnapshot);
                }
                session.flush();
                long savedId = persistentSnapshot.getId();
                int savedVersion = persistentSnapshot.getVersion();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("saved data snapshot " + savedId + " at version " + savedVersion));
                }
                return new DataSnapshotSavedId(savedId, savedVersion, contentsId);
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public long saveDataSnapshot(final ExecutionContext context, final DataCacheSnapshotData snapshot) {
        return (Long)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Long>(){

            public Long doInHibernate(Session session) throws HibernateException, SQLException {
                PersistentDataSnapshot persistentSnapshot = new PersistentDataSnapshot();
                long contentsId = HibernateDataSnapshotService.this.contentsPersistenceService.saveDataSnapshot(context, snapshot.getSnapshotData());
                persistentSnapshot.setContentsId(contentsId);
                DataCacheSnapshotMetadata snapshotMeta = snapshot.getMetadata();
                persistentSnapshot.setSnapshotDate(snapshotMeta.getSnapshotDate());
                Map<String, Object> paramsCopy = HibernateDataSnapshotService.this.copyParams(snapshotMeta.getParameters());
                persistentSnapshot.setDataParameters(paramsCopy);
                session.save((Object)persistentSnapshot);
                session.flush();
                long savedId = persistentSnapshot.getId();
                int savedVersion = persistentSnapshot.getVersion();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("saved data snapshot " + savedId + " at version " + savedVersion));
                }
                return savedId;
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void deleteSnapshot(long snapshotId) {
        PersistentDataSnapshot persistentSnapshot;
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleting snapshot " + snapshotId));
        }
        if ((persistentSnapshot = (PersistentDataSnapshot)this.getHibernateTemplate().get(PersistentDataSnapshot.class, (Serializable)Long.valueOf(snapshotId))) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("didn't find snapshot " + snapshotId + " for deletion "));
            }
            return;
        }
        long contentsId = persistentSnapshot.getContentsId();
        this.contentsPersistenceService.deleteDataSnapshot(null, contentsId);
        this.getHibernateTemplate().delete((Object)persistentSnapshot);
    }

    public Long copyDataSnapshot(long snapshotId) {
        PersistentDataSnapshot persistentSnapshot;
        if (log.isDebugEnabled()) {
            log.debug((Object)("copying snapshot " + snapshotId));
        }
        if ((persistentSnapshot = (PersistentDataSnapshot)this.getHibernateTemplate().get(PersistentDataSnapshot.class, (Serializable)Long.valueOf(snapshotId))) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("didn't find snapshot " + snapshotId + " for copying"));
            }
            return null;
        }
        long contentsId = persistentSnapshot.getContentsId();
        final Long copyContentsId = this.contentsPersistenceService.copyDataSnapshot(contentsId);
        if (copyContentsId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("failed to copy snapshot contents for id " + contentsId));
            }
            return null;
        }
        return (Long)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Long>(){

            public Long doInHibernate(Session session) throws HibernateException, SQLException {
                PersistentDataSnapshot copy = new PersistentDataSnapshot();
                copy.setSnapshotDate(persistentSnapshot.getSnapshotDate());
                copy.setContentsId(copyContentsId);
                copy.setDataParameters(HibernateDataSnapshotService.this.copyParams(persistentSnapshot.getDataParameters()));
                session.save((Object)copy);
                session.flush();
                long savedId = copy.getId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("saved data snapshot copy " + savedId));
                }
                return savedId;
            }
        });
    }

    public DataSnapshotContentsPersistenceService getContentsPersistenceService() {
        return this.contentsPersistenceService;
    }

    public void setContentsPersistenceService(DataSnapshotContentsPersistenceService contentsPersistenceService) {
        this.contentsPersistenceService = contentsPersistenceService;
    }
}

