/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.security;

import com.jaspersoft.jasperserver.api.metadata.security.BasicObjectPermissionArgumentVoter;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.GrantedAuthority;

public class IsRecipientOwnPermissionArgumentVoter
extends BasicObjectPermissionArgumentVoter {
    private static final String ATTRIBUTE = "PERMISSION_RECIPIENT";

    @Override
    protected boolean isPermitted(Authentication authentication, ObjectPermission objectPermission, Object object) {
        boolean res = false;
        if (objectPermission.getPermissionRecipient() instanceof User) {
            User recipient = (User)objectPermission.getPermissionRecipient();
            User user = (User)authentication.getPrincipal();
            res = (recipient.getUsername() == user.getUsername() || recipient.getUsername() != null && recipient.getUsername().equals(user.getUsername())) && (recipient.getTenantId() == user.getTenantId() || recipient.getTenantId() != null && recipient.getTenantId().equals(user.getTenantId()));
        } else if (objectPermission.getPermissionRecipient() instanceof Role) {
            GrantedAuthority[] authorities;
            Role recipient = (Role)objectPermission.getPermissionRecipient();
            for (GrantedAuthority authority : authorities = authentication.getAuthorities()) {
                String tenantId;
                String name = authority.getAuthority();
                String string = tenantId = authority instanceof TenantQualified ? ((TenantQualified)authority).getTenantId() : null;
                if (!name.equals(recipient.getRoleName()) || tenantId != recipient.getTenantId() && (tenantId == null || !tenantId.equals(recipient.getTenantId()))) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    public boolean supports(ConfigAttribute attribute) {
        return ATTRIBUTE.equals(attribute.getAttribute());
    }
}

