/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.encryption;

import com.jaspersoft.jasperserver.api.security.SecurityConfiguration;
import com.jaspersoft.jasperserver.api.security.encryption.Encryption;
import com.jaspersoft.jasperserver.api.security.encryption.EncryptionRSA;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V1CertificateGenerator;
import org.json.JSONObject;

public class EncryptionManager {
    private static final Logger logger = Logger.getLogger(EncryptionManager.class);
    public static final String KEYPAIR_SESSION_KEY = "KEYPAIR_SESSION_KEY";
    public static final String UTF8_ENCODING = "UTF-8";
    private static Encryption encryption = new EncryptionRSA();

    public boolean isEncryptionProcessOn() {
        return SecurityConfiguration.isEncryptionOn();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyPair generateKeys(boolean isDynamicKeygenPerRequest) throws IOException, KeyStoreException {
        if (isDynamicKeygenPerRequest) {
            logger.debug((Object)"Generated keys on the fly successfully.");
            return encryption.generateKeypair(SecurityConfiguration.getEncryptionKeySize());
        }
        Class<EncryptionManager> clazz = EncryptionManager.class;
        synchronized (EncryptionManager.class) {
            InputStream is = null;
            OutputStream os = null;
            try {
                String keystoreLocation = SecurityConfiguration.getKeystoreLocation();
                String keystorePassword = SecurityConfiguration.getKeystorePassword();
                String keyAlias = SecurityConfiguration.getKeystoreKeyAlias();
                String keyPassword = SecurityConfiguration.getKeystoreKeyPassword();
                if (keystoreLocation == null || keystoreLocation.trim().length() == 0 || keyAlias == null || keyAlias.trim().length() == 0) {
                    throw new RuntimeException("At least keystore location and key alias is required.  See docs on setting it up.");
                }
                File keystoreFile = null;
                URL keystoreResource = EncryptionManager.class.getClassLoader().getResource(keystoreLocation);
                is = keystoreResource.openStream();
                if (is == null) {
                    keystoreFile = new File(keystoreLocation);
                    is = new FileInputStream(keystoreLocation);
                } else {
                    keystoreFile = new File(keystoreResource.toURI());
                }
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(is, keystorePassword.toCharArray());
                PublicKey publicKey = null;
                PrivateKey privateKey = null;
                KeyPair returnKeyPair = null;
                if (keyStore.containsAlias(keyAlias)) {
                    KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, new KeyStore.PasswordProtection(keyPassword.toCharArray()));
                    privateKey = privateKeyEntry.getPrivateKey();
                    publicKey = privateKeyEntry.getCertificate().getPublicKey();
                    returnKeyPair = new KeyPair(publicKey, privateKey);
                } else {
                    if (is != null) {
                        is.close();
                    }
                    os = new FileOutputStream(keystoreFile);
                    returnKeyPair = encryption.generateKeypair(SecurityConfiguration.getEncryptionKeySize());
                    Certificate certificate = EncryptionManager.createCertificate(returnKeyPair);
                    keyStore.setKeyEntry(keyAlias, returnKeyPair.getPrivate(), keyPassword.toCharArray(), new Certificate[]{certificate});
                    keyStore.store(os, keystorePassword.toCharArray());
                }
                logger.debug((Object)("Red/generated key pair (" + keyAlias + ") in keystore (" + keystoreFile.getAbsolutePath() + ") successfully."));
                KeyPair keyPair = returnKeyPair;
                // ** MonitorExit[clazz] (shouldn't be in output)
                return keyPair;
            }
            catch (Exception e) {
                throw new RuntimeException("Exception loading keystore and reading the keys.", e);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    private static Certificate createCertificate(KeyPair keyPair) {
        try {
            Calendar expiry = Calendar.getInstance();
            expiry.add(1, 100);
            X509V1CertificateGenerator certGenerator = new X509V1CertificateGenerator();
            X509Principal dnName = new X509Principal("CN=Jaspersoft Inc.");
            certGenerator.setSubjectDN((X509Name)dnName);
            certGenerator.setIssuerDN((X509Name)dnName);
            certGenerator.setNotAfter(expiry.getTime());
            certGenerator.setNotBefore(new Date());
            certGenerator.setPublicKey(keyPair.getPublic());
            certGenerator.setSerialNumber(BigInteger.valueOf(expiry.getTimeInMillis()));
            certGenerator.setSignatureAlgorithm("MD5withRSA");
            return certGenerator.generate(keyPair.getPrivate(), BouncyCastleProvider.PROVIDER_NAME);
        }
        catch (Exception e) {
            logger.error((Object)"Error creating certificate.", (Throwable)e);
            throw new RuntimeException("Error creating certificate.", e);
        }
    }

    public List<String> decrypt(PrivateKey privateKey, String ... encryptedValues) {
        ArrayList<String> retList = new ArrayList<String>(encryptedValues.length);
        try {
            if (privateKey != null) {
                for (String encryptedValue : encryptedValues) {
                    if (encryptedValue.trim().length() == 0) {
                        retList.add(encryptedValue);
                        continue;
                    }
                    String decryptedValue = encryption.decrypt(encryptedValue, privateKey);
                    if (decryptedValue != null && decryptedValue.length() > 0) {
                        try {
                            decryptedValue = URLDecoder.decode(decryptedValue, UTF8_ENCODING);
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.error((Object)"UTF-8 encoding not supported");
                        }
                    } else {
                        decryptedValue = encryptedValue;
                        logger.warn((Object)"Cannot decrypt encryptedValue (hidden for security reasons).");
                    }
                    retList.add(decryptedValue);
                }
                return retList;
            }
            throw new RuntimeException("privateKey is NULL when attempting to decrypt!");
        }
        catch (Exception e) {
            logger.warn((Object)"failed to decrypt. assuming plain text ");
            retList.addAll(Arrays.asList(encryptedValues));
            return retList;
        }
    }

    public static boolean isEncryptedParam(String param) {
        return SecurityConfiguration.getEncryptionParameters().contains(param);
    }

    public static boolean maybeEncryptedJSONParam(String param) {
        Set<String> encParamSet = SecurityConfiguration.getEncryptionParameters();
        for (String encParam : encParamSet) {
            if (!encParam.startsWith(param)) continue;
            return true;
        }
        return false;
    }

    protected static JSONObject buildPublicKeyJSON(PublicKey pubKey) throws IOException {
        try {
            if (encryption instanceof EncryptionRSA) {
                String exponent = EncryptionRSA.getPublicKeyExponent(pubKey);
                String modulus = EncryptionRSA.getPublicKeyModulus(pubKey);
                String maxDigits = String.valueOf(EncryptionRSA.getMaxDigits(SecurityConfiguration.getEncryptionKeySize()));
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("e", (Object)exponent);
                jsonObj.put("n", (Object)modulus);
                jsonObj.put("maxdigits", (Object)maxDigits);
                return jsonObj;
            }
            throw new RuntimeException("Encryption algorithm" + SecurityConfiguration.getEncryptionType() + " is not implemented.");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to respond with a key pair.", e);
        }
    }

    private static enum EncryptionTypes {
        RSA;

    }
}

