/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.controller;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.EmptyThreadLocalStackException;
import com.tonbeller.wcf.controller.ThreadLocalStack;
import com.tonbeller.wcf.convert.Converter;
import com.tonbeller.wcf.expr.ExprContext;
import com.tonbeller.wcf.format.Formatter;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class RequestContext
implements ExprContext {
    private static ThreadLocalStack instanceStack = new ThreadLocalStack();
    private static final String RESPONSE_COMPLETE_KEY = RequestContext.class.getName() + ".responseComplete";

    public abstract HttpServletRequest getRequest();

    public abstract HttpServletResponse getResponse();

    public abstract ServletContext getServletContext();

    public abstract HttpSession getSession();

    public abstract Converter getConverter();

    public abstract Formatter getFormatter();

    public abstract Map getFileParameters();

    protected RequestContext() {
    }

    public static RequestContext instance() throws EmptyThreadLocalStackException {
        return (RequestContext)instanceStack.peek(true);
    }

    public static RequestContext instance(boolean failIfEmpty) throws EmptyThreadLocalStackException {
        return (RequestContext)instanceStack.peek(failIfEmpty);
    }

    public static void setInstance(RequestContext context) {
        instanceStack.push(context);
    }

    public void invalidate() {
        instanceStack.pop();
    }

    public abstract Map getParameters();

    public abstract String[] getParameters(String var1);

    public abstract String getParameter(String var1);

    public abstract Locale getLocale();

    public abstract void setLocale(Locale var1);

    public abstract Resources getResources();

    public abstract Resources getResources(String var1);

    public abstract Resources getResources(Class var1);

    public abstract Object getModelReference(String var1);

    public abstract void setModelReference(String var1, Object var2);

    public abstract boolean isUserInRole(String var1);

    public abstract String getRemoteUser();

    public abstract String getRemoteDomain();

    public abstract boolean isAdmin();

    public void setResponseComplete(boolean complete) {
        this.getRequest().setAttribute(RESPONSE_COMPLETE_KEY, (Object)Boolean.toString(complete));
    }

    public boolean isResponseComplete() {
        return "true".equals(this.getRequest().getAttribute(RESPONSE_COMPLETE_KEY));
    }
}

