/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.pagestack;

import com.tonbeller.wcf.pagestack.Page;
import java.util.Iterator;
import java.util.Stack;
import javax.servlet.http.HttpSession;

public class PageStack {
    public static final String WEBKEY = "wcfPageStack";
    Stack stack = new Stack();

    PageStack() {
    }

    public static synchronized PageStack instance(HttpSession session) {
        PageStack ps = (PageStack)session.getAttribute(WEBKEY);
        if (ps == null) {
            ps = new PageStack();
            session.setAttribute(WEBKEY, (Object)ps);
        }
        return ps;
    }

    public void setCurrentPage(Page page) {
        while (this.stack.contains(page)) {
            this.stack.pop();
        }
        this.stack.push(page);
    }

    public Page peek(int n) {
        n = this.stack.size() - n - 1;
        if (n < 0) {
            return null;
        }
        return (Page)this.stack.get(n);
    }

    public Iterator iterator() {
        return this.stack.iterator();
    }

    public void clear() {
        this.stack.clear();
    }
}

