/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nu.xom.ParsingException;
import nux.xom.io.StaxParser;
import nux.xom.io.StaxUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

final class StaxBuilder
extends Builder {
    private final NodeFactory factory;
    private final XMLInputFactory inputFactory;

    StaxBuilder(XMLInputFactory inputFactory, NodeFactory factory) {
        super((XMLReader)new DummyXMLReader(), false, factory);
        if (inputFactory == null) {
            throw new IllegalArgumentException("XMLInputFactory must not be null");
        }
        this.inputFactory = inputFactory;
        if (factory == null) {
            factory = new NodeFactory();
        }
        this.factory = factory;
    }

    public Document build(InputStream input) throws ParsingException, IOException {
        return this.build(input, null);
    }

    public Document build(InputStream input, String baseURI) throws ParsingException, IOException {
        Document document;
        block2: {
            try {
                XMLStreamReader reader = this.createXMLStreamReader(input, baseURI);
                document = new StaxParser(reader, this.factory).build();
                Object var4_5 = null;
                if (input == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_6 = null;
                    if (input == null) break block3;
                    input.close();
                }
                throw throwable;
            }
            input.close();
        }
        return document;
    }

    public Document build(File file) throws ParsingException, IOException {
        String baseURI = file.toURI().toASCIIString();
        return this.build(new FileInputStream(file), baseURI);
    }

    public Document build(Reader input) throws ParsingException, IOException {
        return this.build(input, null);
    }

    public Document build(Reader input, String baseURI) throws ParsingException, IOException {
        Document document;
        block2: {
            try {
                XMLStreamReader reader = this.createXMLStreamReader(input, baseURI);
                document = new StaxParser(reader, this.factory).build();
                Object var4_5 = null;
                if (input == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_6 = null;
                    if (input == null) break block3;
                    input.close();
                }
                throw throwable;
            }
            input.close();
        }
        return document;
    }

    public Document build(String systemID) throws ParsingException, IOException {
        if (systemID == null) {
            throw new IllegalArgumentException("systemID must not be null");
        }
        return this.build(URI.create(systemID).toURL().openStream(), systemID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLStreamReader createXMLStreamReader(InputStream input, String baseURI) throws ParsingException {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        if (baseURI != null && baseURI.length() == 0) {
            baseURI = null;
        }
        try {
            XMLInputFactory xMLInputFactory = this.inputFactory;
            synchronized (xMLInputFactory) {
                return this.inputFactory.createXMLStreamReader(baseURI, input);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.wrapException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLStreamReader createXMLStreamReader(Reader input, String baseURI) throws ParsingException {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        if (baseURI != null && baseURI.length() == 0) {
            baseURI = null;
        }
        try {
            XMLInputFactory xMLInputFactory = this.inputFactory;
            synchronized (xMLInputFactory) {
                return this.inputFactory.createXMLStreamReader(baseURI, input);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.wrapException(e);
            return null;
        }
    }

    private static final class DummyXMLReader
    implements XMLReader {
        private DummyXMLReader() {
        }

        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return false;
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public void setEntityResolver(EntityResolver resolver) {
        }

        public EntityResolver getEntityResolver() {
            return null;
        }

        public void setDTDHandler(DTDHandler handler) {
        }

        public DTDHandler getDTDHandler() {
            return null;
        }

        public void setContentHandler(ContentHandler handler) {
        }

        public ContentHandler getContentHandler() {
            return null;
        }

        public void setErrorHandler(ErrorHandler handler) {
        }

        public ErrorHandler getErrorHandler() {
            return null;
        }

        public void parse(InputSource input) throws IOException, SAXException {
        }

        public void parse(String systemId) throws IOException, SAXException {
        }
    }
}

