/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nux.xom.pool.BuilderFactory;
import nux.xom.pool.BuilderPool;
import nux.xom.pool.FileUtil;
import nux.xom.pool.PoolConfig;
import nux.xom.pool.XOMUtil;

public final class BuilderPoolBenchmark {
    private BuilderPoolBenchmark() {
    }

    public static void main(String[] args) throws Exception {
        boolean nullNodeFactory;
        int k = 0;
        final boolean isPooled = args[k++].equals("pooled");
        final String fileName = args[k++];
        final String validate = args[k++];
        final int runs = Integer.parseInt(args[k++]);
        final boolean memory = args[k++].equals("memory");
        int numThreads = Integer.parseInt(args[k++]);
        String schema = args.length > k ? args[k++] : null;
        String namespace = args.length > k ? args[k++] : null;
        boolean bl = nullNodeFactory = args.length > k ? new Boolean(args[k++]) : false;
        if (!isPooled && validate.equals("validateschema")) {
            System.setProperty("nux.xom.pool.BuilderPool.maxPoolEntries", "0");
        }
        System.out.println("fileName=" + fileName);
        System.out.println("schema=" + schema);
        System.out.println("namespace=" + namespace);
        if (!new File(schema).exists()) {
            throw new RuntimeException("File '" + schema + "' not found.");
        }
        final HashMap<File, String> map = new HashMap<File, String>();
        map.put(new File(schema), namespace);
        byte[] b = new byte[]{};
        if (memory && !fileName.equals("nofile")) {
            b = FileUtil.toByteArray(new FileInputStream(fileName));
        }
        final byte[] bytes = b;
        final BuilderPool pool = !nullNodeFactory ? BuilderPool.GLOBAL_POOL : new BuilderPool(new PoolConfig(), new BuilderFactory(){

            protected NodeFactory createNodeFactory() {
                return XOMUtil.getNullNodeFactory();
            }
        });
        int i = 0;
        while (i < 100) {
            new Builder(false);
            new Builder(true);
            pool.getW3CBuilder(map);
            ++i;
        }
        System.gc();
        Thread.sleep(1000L);
        long start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < numThreads) {
            Thread thread = new Thread(){
                int checksum = 0;

                public void run() {
                    try {
                        int i = 0;
                        while (i < runs) {
                            this.bench();
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                private void bench() throws Exception {
                    Builder builder = validate.equals("validateschema") ? pool.getW3CBuilder(map) : (isPooled ? pool.getBuilder(validate.equals("validate")) : new Builder(validate.equals("validate")));
                    this.checksum += builder.hashCode();
                    if (!fileName.equals("nofile")) {
                        Document doc = memory ? builder.build((InputStream)new ByteArrayInputStream(bytes, 0, bytes.length)) : builder.build((InputStream)new FileInputStream(fileName));
                        this.checksum += doc.getChildCount();
                    }
                }
            };
            thread.start();
            thread.join();
            ++i2;
        }
        long end = System.currentTimeMillis();
        System.out.println("\n" + runs + " runs took " + (float)(end - start) / 1000.0f + " secs");
        System.out.println("--> " + (float)(numThreads * runs) / ((float)(end - start) / 1000.0f) + " iters/secs");
    }

    private static String getAbsoluteURI(String fileOrURI) {
        URI uri = null;
        try {
            uri = new URI(fileOrURI);
        }
        catch (URISyntaxException e) {
            uri = new File(fileOrURI).toURI();
        }
        if (uri.getScheme() == null) {
            uri = new File(fileOrURI).toURI();
        }
        if (uri.getScheme().equals("file") && !new File(uri.getPath()).exists()) {
            throw new RuntimeException("File '" + fileOrURI + "' not found.");
        }
        return uri.toString();
    }
}

