/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.keymappers;

import org.infinispan.loaders.keymappers.TwoWayKey2StringMapper;
import org.infinispan.util.Base64;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultTwoWayKey2StringMapper
implements TwoWayKey2StringMapper {
    private static final Log log = LogFactory.getLog(DefaultTwoWayKey2StringMapper.class);
    private static final char NON_STRING_PREFIX = '\ufeff';
    private static final char SHORT_IDENTIFIER = '1';
    private static final char BYTE_IDENTIFIER = '2';
    private static final char LONG_IDENTIFIER = '3';
    private static final char INTEGER_IDENTIFIER = '4';
    private static final char DOUBLE_IDENTIFIER = '5';
    private static final char FLOAT_IDENTIFIER = '6';
    private static final char BOOLEAN_IDENTIFIER = '7';
    private static final char BYTEARRAYKEY_IDENTIFIER = '8';

    @Override
    public String getStringMapping(Object key) {
        int identifier;
        if (key.getClass().equals(String.class)) {
            return key.toString();
        }
        if (key.getClass().equals(Short.class)) {
            identifier = 49;
        } else if (key.getClass().equals(Byte.class)) {
            identifier = 50;
        } else if (key.getClass().equals(Long.class)) {
            identifier = 51;
        } else if (key.getClass().equals(Integer.class)) {
            identifier = 52;
        } else if (key.getClass().equals(Double.class)) {
            identifier = 53;
        } else if (key.getClass().equals(Float.class)) {
            identifier = 54;
        } else if (key.getClass().equals(Boolean.class)) {
            identifier = 55;
        } else {
            if (key.getClass().equals(ByteArrayKey.class)) {
                return this.generateString('8', Base64.encodeBytes(((ByteArrayKey)key).getData()));
            }
            throw new IllegalArgumentException("Unsupported key type: " + key.getClass().getName());
        }
        return this.generateString((char)identifier, key.toString());
    }

    @Override
    public Object getKeyMapping(String key) {
        log.tracef("Get mapping for key: %s", key);
        if (key.length() > 0 && key.charAt(0) == '\ufeff') {
            char type = key.charAt(1);
            String value = key.substring(2);
            switch (type) {
                case '1': {
                    return Short.parseShort(value);
                }
                case '2': {
                    return Byte.parseByte(value);
                }
                case '3': {
                    return Long.parseLong(value);
                }
                case '4': {
                    return Integer.parseInt(value);
                }
                case '5': {
                    return Double.parseDouble(value);
                }
                case '6': {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case '7': {
                    return Boolean.parseBoolean(value);
                }
                case '8': {
                    return new ByteArrayKey(Base64.decode(value));
                }
            }
            throw new IllegalArgumentException("Unsupported type code: " + type);
        }
        return key;
    }

    @Override
    public boolean isSupportedType(Class<?> keyType) {
        return DefaultTwoWayKey2StringMapper.isPrimitive(keyType);
    }

    private String generateString(char identifier, String s) {
        return String.valueOf('\ufeff') + String.valueOf(identifier) + s;
    }

    static boolean isPrimitive(Class<?> key) {
        return key == String.class || key == Short.class || key == Byte.class || key == Long.class || key == Integer.class || key == Double.class || key == Float.class || key == Boolean.class || key == ByteArrayKey.class;
    }
}

