/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.Util;

public class GlobalTransaction
implements Cloneable {
    private static final long serialVersionUID = 8011434781266976149L;
    private static AtomicLong sid = new AtomicLong(0L);
    long id = -1L;
    protected transient Address addr = null;
    private transient int hash_code = -1;
    private transient boolean remote = false;

    protected GlobalTransaction() {
    }

    protected GlobalTransaction(Address addr, boolean remote) {
        this.id = sid.incrementAndGet();
        this.addr = addr;
        this.remote = remote;
    }

    public Address getAddress() {
        return this.addr;
    }

    public long getId() {
        return this.id;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public int hashCode() {
        if (this.hash_code == -1) {
            this.hash_code = (this.addr != null ? this.addr.hashCode() : 0) + (int)this.id;
        }
        return this.hash_code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlobalTransaction)) {
            return false;
        }
        GlobalTransaction otherGtx = (GlobalTransaction)other;
        boolean aeq = this.addr == null ? otherGtx.addr == null : this.addr.equals(otherGtx.addr);
        return aeq && this.id == otherGtx.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GlobalTransaction:<").append(this.addr).append(">:").append(this.id).append(this.isRemote() ? ":remote" : ":local");
        return sb.toString();
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setAddress(Address address) {
        this.addr = address;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!");
        }
    }

    public static class Externalizer
    extends AbstractGlobalTxExternalizer<GlobalTransaction> {
        @Override
        public Set<Class<? extends GlobalTransaction>> getTypeClasses() {
            return Util.asSet(GlobalTransaction.class);
        }

        @Override
        public Integer getId() {
            return 38;
        }

        @Override
        protected GlobalTransaction createGlobalTransaction() {
            return TransactionFactory.TxFactoryEnum.NODLD_NORECOVERY_XA.newGlobalTransaction();
        }
    }

    protected static abstract class AbstractGlobalTxExternalizer<T extends GlobalTransaction>
    extends AbstractExternalizer<T> {
        protected AbstractGlobalTxExternalizer() {
        }

        @Override
        public void writeObject(ObjectOutput output, T gtx) throws IOException {
            output.writeLong(((GlobalTransaction)gtx).id);
            output.writeObject(((GlobalTransaction)gtx).addr);
        }

        protected abstract T createGlobalTransaction();

        @Override
        public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            T gtx = this.createGlobalTransaction();
            ((GlobalTransaction)gtx).id = input.readLong();
            ((GlobalTransaction)gtx).addr = (Address)input.readObject();
            return gtx;
        }
    }
}

