/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberListCalc;
import mondrian.calc.TupleListCalc;
import mondrian.calc.impl.AbstractMemberListCalc;
import mondrian.calc.impl.AbstractTupleListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.VisualTotalsFunDef;
import mondrian.olap.type.SetType;

class IntersectFunDef
extends FunDefBase {
    private static final String[] ReservedWords = new String[]{"ALL"};
    static final Resolver resolver = new ReflectiveMultiResolver("Intersect", "Intersect(<Set1>, <Set2>[, ALL])", "Returns the intersection of two input sets, optionally retaining duplicates.", new String[]{"fxxxy", "fxxx"}, IntersectFunDef.class, ReservedWords);

    public IntersectFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        String literalArg = IntersectFunDef.getLiteralArg(call, 2, "", ReservedWords);
        final boolean all = literalArg.equalsIgnoreCase("ALL");
        int arity = ((SetType)call.getType()).getArity();
        if (arity == 1) {
            final MemberListCalc listCalc1 = (MemberListCalc)compiler.compileList(call.getArg(0));
            final MemberListCalc listCalc2 = (MemberListCalc)compiler.compileList(call.getArg(1));
            return new AbstractMemberListCalc(call, new Calc[]{listCalc1, listCalc2}){

                @Override
                public List<Member> evaluateMemberList(Evaluator evaluator) {
                    List<Member> leftList = listCalc1.evaluateMemberList(evaluator);
                    if (leftList.isEmpty()) {
                        return Collections.emptyList();
                    }
                    List<Member> rightList = listCalc2.evaluateMemberList(evaluator);
                    if (rightList.isEmpty()) {
                        return Collections.emptyList();
                    }
                    RetrievableHashSet<Member> rightSet = new RetrievableHashSet<Member>();
                    for (Member member : rightList) {
                        rightSet.add(member);
                    }
                    ArrayList<Member> result = new ArrayList<Member>();
                    HashSet<Member> resultSet = all ? null : new HashSet<Member>();
                    for (Member leftMember : leftList) {
                        Member rightMember = rightSet.getKey(leftMember);
                        if (rightMember == null || resultSet != null && !resultSet.add(leftMember)) continue;
                        if (rightMember instanceof VisualTotalsFunDef.VisualTotalMember) {
                            result.add(rightMember);
                            continue;
                        }
                        result.add(leftMember);
                    }
                    return result;
                }
            };
        }
        final TupleListCalc listCalc1 = (TupleListCalc)compiler.compileList(call.getArg(0));
        final TupleListCalc listCalc2 = (TupleListCalc)compiler.compileList(call.getArg(1));
        return new AbstractTupleListCalc(call, new Calc[]{listCalc1, listCalc2}){

            @Override
            public List<Member[]> evaluateTupleList(Evaluator evaluator) {
                List<Member[]> leftList = listCalc1.evaluateTupleList(evaluator);
                if (leftList.isEmpty()) {
                    return Collections.emptyList();
                }
                List<Member[]> rightList = listCalc2.evaluateTupleList(evaluator);
                if (rightList.isEmpty()) {
                    return Collections.emptyList();
                }
                RetrievableSet<List<Member>> rightSet = this.buildSearchableCollection(rightList);
                ArrayList<Member[]> result = new ArrayList<Member[]>();
                HashSet<List<Member>> resultSet = all ? null : new HashSet<List<Member>>();
                for (Member[] leftTuple : leftList) {
                    List<Member> leftKey = Arrays.asList(leftTuple);
                    List<Member> rightKey = rightSet.getKey(leftKey);
                    if (rightKey == null || resultSet != null && !resultSet.add(leftKey)) continue;
                    result.add(this.copyTupleWithVisualTotalsMembersOverriding(leftTuple, rightKey));
                }
                return result;
            }

            private Member[] copyTupleWithVisualTotalsMembersOverriding(Member[] leftTuple, List<Member> rightKey) {
                Member[] tuple = leftTuple;
                for (int i = 0; i < rightKey.size(); ++i) {
                    Member member = rightKey.get(i);
                    if (tuple[i] instanceof VisualTotalsFunDef.VisualTotalMember || !(member instanceof VisualTotalsFunDef.VisualTotalMember)) continue;
                    if (tuple == leftTuple) {
                        tuple = (Member[])leftTuple.clone();
                    }
                    tuple[i] = member;
                }
                return tuple;
            }

            private RetrievableSet<List<Member>> buildSearchableCollection(List<Member[]> tuples) {
                RetrievableHashSet<List<Member>> result = new RetrievableHashSet<List<Member>>(tuples.size());
                for (Member[] tuple : tuples) {
                    result.add(Arrays.asList(tuple));
                }
                return result;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RetrievableHashSet<E>
    extends HashMap<E, E>
    implements RetrievableSet<E> {
        public RetrievableHashSet(int initialCapacity) {
            super(initialCapacity);
        }

        public RetrievableHashSet() {
        }

        @Override
        public E getKey(E e) {
            return (E)super.get(e);
        }

        @Override
        public boolean add(E e) {
            return super.put(e, e) == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface RetrievableSet<E> {
        public E getKey(E var1);

        public boolean add(E var1);
    }
}

