/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.action;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.search.action.BaseSearchAction;
import com.jaspersoft.jasperserver.search.helper.PermissionJSONHelper;
import com.jaspersoft.jasperserver.search.model.permission.Permission;
import com.jaspersoft.jasperserver.search.model.permission.PermissionToDisplay;
import com.jaspersoft.jasperserver.search.model.permission.RoleWithPermission;
import com.jaspersoft.jasperserver.search.model.permission.UserWithPermission;
import com.jaspersoft.jasperserver.war.action.EntitiesListManager;
import com.jaspersoft.jasperserver.war.action.EntitiesListState;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ResourcePermissionsAction
extends BaseSearchAction {
    protected static final String PARAMETER_INITIALIZE = "initialize";
    protected static final String PARAMETER_RESOURCE_URI = "uri";
    protected static final String PARAMETER_IS_FOLDER = "isFolder";
    protected static final String PARAMETER_TYPE = "type";
    protected static final String PARAMETER_TEXT = "text";
    protected static final String PARAMETER_ENTITIES_WITH_PERMISSION = "entitiesWithPermission";
    protected static final String RESOURCE_URI_PREFIX = "repo:";
    private PermissionJSONHelper permissionJSONHelper;
    private ObjectPermissionService objectPermissionService;
    private RepositoryService repository;
    private UserAuthorityService userService;
    private ConfigurationBean configuration;
    private List<String> rolesToDisablePermissionEditForEveryone;
    private List<String> rolesToDisablePermissionEditForNonSuperuser;
    private String roleSuperuser;
    private String defaultSuperuserUsername;

    public Event browse(RequestContext context) {
        State state = this.getState(context);
        String resourceUri = this.getResourceUri(context);
        ResourcePermissionsState resourcePermissionsState = state.getResourcePermissionsStateMap().get(resourceUri);
        if (resourcePermissionsState == null) {
            resourcePermissionsState = new ResourcePermissionsState();
            resourcePermissionsState.setResourceUri(resourceUri);
            resourcePermissionsState.setFolder(Boolean.parseBoolean(this.getParameter(context, PARAMETER_IS_FOLDER)));
            resourcePermissionsState.setResource(this.getResource(context, resourcePermissionsState.getResourceUri(), resourcePermissionsState.isFolder()));
            state.getResourcePermissionsStateMap().put(resourceUri, resourcePermissionsState);
        } else {
            resourcePermissionsState.getEntitiesListState().updateResultState(0, 0);
            String initialize = this.getParameter(context, PARAMETER_INITIALIZE);
            if (Boolean.parseBoolean(initialize)) {
                resourcePermissionsState.getEntitiesListState().updateText(null);
            }
        }
        resourcePermissionsState.setObjectType(ObjectType.valueOf(this.getParameter(context, PARAMETER_TYPE)));
        return this.success();
    }

    public Event search(RequestContext context) {
        String resourceUri = this.getResourceUri(context);
        ResourcePermissionsState resourcePermissionsState = this.getState(context).getResourcePermissionsStateMap().get(resourceUri);
        if (resourcePermissionsState == null) {
            return this.error(new IllegalStateException("Search action performed before browse action (initialization) [resourceUri=\"" + resourceUri + "\"]."));
        }
        resourcePermissionsState.getEntitiesListState().updateText(this.getParameter(context, PARAMETER_TEXT));
        return this.success();
    }

    public Event next(RequestContext context) {
        JSONObject responseModel;
        String resourceUri = this.getResourceUri(context);
        ResourcePermissionsState resourcePermissionsState = this.getState(context).getResourcePermissionsStateMap().get(resourceUri);
        if (resourcePermissionsState == null) {
            return this.error(new IllegalStateException("Next action performed before browse action (initialization) [resourceUri=\"" + resourceUri + "\"]."));
        }
        try {
            JSONObject json;
            final ExecutionContext executionContext = this.getExecutionContext(context);
            final Set<String> tenantIdSet = this.getEffectiveTenantIds(resourcePermissionsState, executionContext);
            final EntitiesListState entitiesListState = resourcePermissionsState.getEntitiesListState();
            switch (resourcePermissionsState.getObjectType()) {
                case USER: {
                    List users = this.getEntitiesAndUpdateState(entitiesListState, this.configuration.getRoleItemsPerPage(), new EntitiesListManager(){

                        public int getResultsCount() {
                            return ResourcePermissionsAction.this.userService.getTenantUsersCount(executionContext, tenantIdSet, entitiesListState.getText());
                        }

                        public List getResults(int resultIndex, int maxResults) {
                            return ResourcePermissionsAction.this.userService.getTenantUsers(executionContext, tenantIdSet, entitiesListState.getText(), resultIndex, maxResults);
                        }
                    });
                    List<UserWithPermission> userWithPermissionList = this.getUserWithPermissionList(context, users, resourcePermissionsState);
                    json = this.permissionJSONHelper.createUserWithPermissionsJson(userWithPermissionList, resourcePermissionsState.getObjectType().name());
                    break;
                }
                case ROLE: {
                    List roles = this.getEntitiesAndUpdateState(entitiesListState, this.configuration.getRoleItemsPerPage(), new EntitiesListManager(){

                        public int getResultsCount() {
                            return ResourcePermissionsAction.this.userService.getTenantVisibleRolesCount(executionContext, tenantIdSet, entitiesListState.getText());
                        }

                        public List getResults(int resultIndex, int maxResults) {
                            return ResourcePermissionsAction.this.userService.getTenantVisibleRoles(executionContext, tenantIdSet, entitiesListState.getText(), resultIndex, maxResults);
                        }
                    });
                    List<RoleWithPermission> roleWithPermissionList = this.getRoleWithPermissionList(context, roles, resourcePermissionsState);
                    json = this.permissionJSONHelper.createRoleWithPermissionsJson(roleWithPermissionList, resourcePermissionsState.getObjectType().name());
                    break;
                }
                default: {
                    return this.error(new IllegalArgumentException("Object type is not supported [type=\"" + (Object)((Object)resourcePermissionsState.getObjectType()) + "\"]"));
                }
            }
            responseModel = this.getConverter(context).createJSONResponse(json);
        }
        catch (Exception e) {
            try {
                responseModel = this.getConverter(context).createErrorJSONResponse(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel.toString());
        return this.success();
    }

    public Event updatePermissions(RequestContext context) {
        JSONObject responseModel;
        String resourceUri = this.getResourceUri(context);
        ResourcePermissionsState resourcePermissionsState = this.getState(context).getResourcePermissionsStateMap().get(resourceUri);
        if (resourcePermissionsState == null) {
            return this.error(new IllegalStateException("UpdatePermissions action performed before browse action (initialization) [resourceUri=\"" + resourceUri + "\"]."));
        }
        String entitiesWithPermissionJson = this.getParameter(context, PARAMETER_ENTITIES_WITH_PERMISSION);
        if (entitiesWithPermissionJson == null) {
            return this.error(new IllegalArgumentException("Request parameter \"entitiesWithPermission\" is missed"));
        }
        try {
            JSONObject json;
            switch (resourcePermissionsState.getObjectType()) {
                case USER: {
                    Set<UserWithPermission> userWithPermissionSet = this.permissionJSONHelper.convertJsonArrayToUserWithPermissionSet(entitiesWithPermissionJson);
                    this.updateUserPermissions(context, resourcePermissionsState, userWithPermissionSet);
                    List<UserWithPermission> userWithPermissionList = this.getUserWithPermissionList(context, this.extractUsers(userWithPermissionSet), resourcePermissionsState);
                    json = this.permissionJSONHelper.createUserWithPermissionsJson(userWithPermissionList, resourcePermissionsState.getObjectType().name());
                    break;
                }
                case ROLE: {
                    Set<RoleWithPermission> roleWithPermissionSet = this.permissionJSONHelper.convertJsonArrayToRoleWithPermissionSet(entitiesWithPermissionJson);
                    this.updateRolePermissions(context, resourcePermissionsState, roleWithPermissionSet);
                    List<RoleWithPermission> roleWithPermissionList = this.getRoleWithPermissionList(context, this.extractRoles(roleWithPermissionSet), resourcePermissionsState);
                    json = this.permissionJSONHelper.createRoleWithPermissionsJson(roleWithPermissionList, resourcePermissionsState.getObjectType().name());
                    break;
                }
                default: {
                    return this.error(new IllegalArgumentException("Object type is not supported [type=\"" + (Object)((Object)resourcePermissionsState.getObjectType()) + "\"]"));
                }
            }
            responseModel = this.getConverter(context).createJSONResponse(json);
        }
        catch (Exception e) {
            try {
                responseModel = this.getConverter(context).createErrorJSONResponse(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel.toString());
        return this.success();
    }

    private void updateUserPermissions(RequestContext context, ResourcePermissionsState resourcePermissionsState, Set<UserWithPermission> userWithPermissionSet) {
        for (UserWithPermission userWithPermission : userWithPermissionSet) {
            this.updateRecipientPermission(context, resourcePermissionsState, userWithPermission.getUser(), userWithPermission.getPermissionToDisplay());
        }
    }

    private void updateRolePermissions(RequestContext context, ResourcePermissionsState resourcePermissionsState, Set<RoleWithPermission> roleWithPermissionSet) {
        for (RoleWithPermission roleWithPermission : roleWithPermissionSet) {
            this.updateRecipientPermission(context, resourcePermissionsState, roleWithPermission.getRole(), roleWithPermission.getPermissionToDisplay());
        }
    }

    private void updateRecipientPermission(RequestContext context, ResourcePermissionsState resourcePermissionsState, Object recipient, PermissionToDisplay permissionToDisplay) {
        Resource resource = resourcePermissionsState.getResource();
        ExecutionContext executionContext = this.getExecutionContext(context);
        if (permissionToDisplay.getNewPermission() != null) {
            if (permissionToDisplay.isInherited()) {
                if (permissionToDisplay.getNewPermission() != permissionToDisplay.getInheritedPermission()) {
                    this.performObjectPermissionSave(executionContext, resource, recipient, permissionToDisplay.getNewPermission().getMask());
                }
            } else if (permissionToDisplay.getNewPermission() != permissionToDisplay.getPermission()) {
                if (permissionToDisplay.getNewPermission() == permissionToDisplay.getInheritedPermission()) {
                    this.performObjectPermissionDelete(executionContext, resource, recipient);
                } else {
                    this.performObjectPermissionSave(executionContext, resource, recipient, permissionToDisplay.getNewPermission().getMask());
                }
            }
        }
    }

    private Set<String> getEffectiveTenantIds(ResourcePermissionsState resourcePermissionsState, ExecutionContext executionContext) {
        String resourceTenantId;
        Tenant resourceTenant = this.tenantService.getTenantBasedOnRepositoryUri(executionContext, resourcePermissionsState.getResourceUri());
        String string = resourceTenantId = resourceTenant == null ? "organizations" : resourceTenant.getId();
        if (resourcePermissionsState.getResourceUri().startsWith(this.configuration.getPublicFolderUri())) {
            String currentTenantId = this.getCurrentTenantId();
            return this.getSubTenantIdsSet(currentTenantId == null ? "organizations" : currentTenantId);
        }
        return this.getTenantIdsBetween(executionContext, this.getCurrentTenantId(), resourceTenantId);
    }

    protected State getState(RequestContext context) {
        Object state = super.getState(context);
        if (state == null) {
            this.initState(context);
            state = super.getState(context);
        }
        return (State)state;
    }

    protected void initState(RequestContext context) {
        State state = new State();
        this.putState(context, state);
    }

    private String getResourceUri(RequestContext context) {
        String resourceUri = this.getParameter(context, PARAMETER_RESOURCE_URI);
        if (resourceUri.startsWith(RESOURCE_URI_PREFIX)) {
            resourceUri = resourceUri.substring(RESOURCE_URI_PREFIX.length());
        }
        return resourceUri;
    }

    private List<UserWithPermission> getUserWithPermissionList(RequestContext context, List<User> users, ResourcePermissionsState resourcePermissionsState) {
        ArrayList<UserWithPermission> userWithPermissionList = new ArrayList<UserWithPermission>(users.size());
        for (User user : users) {
            UserWithPermission userWithPermission = new UserWithPermission();
            userWithPermission.setUser(user);
            userWithPermission.setPermissionToDisplay(this.getPermission(this.getExecutionContext(context), resourcePermissionsState.getResource(), user));
            this.disablePermissionIfRequired(userWithPermission);
            userWithPermissionList.add(userWithPermission);
        }
        return userWithPermissionList;
    }

    private List<RoleWithPermission> getRoleWithPermissionList(RequestContext context, List<Role> roles, ResourcePermissionsState resourcePermissionsState) {
        ArrayList<RoleWithPermission> roleWithPermissionList = new ArrayList<RoleWithPermission>(roles.size());
        for (Role role : roles) {
            RoleWithPermission roleWithPermission = new RoleWithPermission();
            roleWithPermission.setRole(role);
            roleWithPermission.setPermissionToDisplay(this.getPermission(this.getExecutionContext(context), resourcePermissionsState.getResource(), role));
            this.disablePermissionIfRequired(roleWithPermission);
            roleWithPermissionList.add(roleWithPermission);
        }
        return roleWithPermissionList;
    }

    private void disablePermissionIfRequired(UserWithPermission userWithPermission) {
        boolean isPermissionForCurrentUser;
        String currentUsername = this.getCurrentUsername();
        String currentTenantId = this.getCurrentTenantId();
        boolean isPermissionForDefaultSuperuser = currentTenantId == null && this.defaultSuperuserUsername.equals(currentUsername) && userWithPermission.getUser().getTenantId() == null && userWithPermission.getUser().getUsername().equals(this.defaultSuperuserUsername);
        boolean bl = isPermissionForCurrentUser = userWithPermission.getUser().getUsername().equals(currentUsername) && (currentTenantId == null && userWithPermission.getUser().getTenantId() == null || currentTenantId != null && userWithPermission.getUser().getTenantId().equals(currentTenantId));
        if (isPermissionForDefaultSuperuser || isPermissionForCurrentUser) {
            userWithPermission.getPermissionToDisplay().setDisabled(true);
        }
    }

    private void disablePermissionIfRequired(RoleWithPermission roleWithPermission) {
        if (this.rolesToDisablePermissionEditForEveryone.contains(roleWithPermission.getRole().getRoleName())) {
            roleWithPermission.getPermissionToDisplay().setDisabled(true);
        }
        List roles = this.getCurrentUserRoles();
        boolean hasSuperuserRole = false;
        for (Role role : roles) {
            if (!role.getRoleName().equals(this.roleSuperuser)) continue;
            hasSuperuserRole = true;
        }
        if (!hasSuperuserRole && this.rolesToDisablePermissionEditForNonSuperuser.contains(roleWithPermission.getRole().getRoleName())) {
            roleWithPermission.getPermissionToDisplay().setDisabled(true);
        }
    }

    private PermissionToDisplay getPermission(ExecutionContext executionContext, Resource resource, Object recipient) {
        List permissions = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(executionContext, (Object)resource, recipient);
        PermissionToDisplay permissionToDisplay = new PermissionToDisplay();
        if (permissions != null && permissions.size() > 0) {
            ObjectPermission objectPermission = (ObjectPermission)permissions.get(0);
            if (objectPermission != null && objectPermission.getPermissionRecipient() != null) {
                permissionToDisplay.setPermission(Permission.getByMask(objectPermission.getPermissionMask()));
                permissionToDisplay.setInheritedPermission(Permission.getByMask(this.objectPermissionService.getInheritedObjectPermissionMask(executionContext, (Object)resource, recipient)));
            }
        } else {
            permissionToDisplay.setInherited(true);
            permissionToDisplay.setInheritedPermission(Permission.getByMask(this.objectPermissionService.getInheritedObjectPermissionMask(executionContext, (Object)resource, recipient)));
        }
        return permissionToDisplay;
    }

    private Resource getResource(RequestContext context, String resourceUri, boolean isFolder) {
        ExecutionContext executionContext = this.getExecutionContext(context);
        if (isFolder) {
            return this.repository.getFolder(executionContext, resourceUri);
        }
        return this.repository.getResource(executionContext, resourceUri);
    }

    private Set<String> getTenantIdsBetween(ExecutionContext executionContext, String topTenantId, String bottomTenantId) {
        String string = topTenantId = topTenantId == null ? "organizations" : topTenantId;
        if (topTenantId.equals(bottomTenantId)) {
            return Collections.singleton(topTenantId);
        }
        Tenant topTenant = this.tenantService.getTenant(executionContext, topTenantId);
        Tenant bottomTenant = this.tenantService.getTenant(executionContext, bottomTenantId);
        if (bottomTenant == null || topTenant == null) {
            return Collections.emptySet();
        }
        String topTenantUri = topTenant.getTenantUri();
        String bottomTenantUri = bottomTenant.getTenantUri();
        if (bottomTenantUri.startsWith(topTenantUri)) {
            String subUri = bottomTenantUri.substring(topTenantUri.length());
            String[] betweenTenantIds = subUri.split("/");
            HashSet<String> tenantIdsBetween = new HashSet<String>(Arrays.asList(betweenTenantIds));
            if (topTenantId.equals("organizations")) {
                tenantIdsBetween.add("organizations");
            }
            String topTenantParentId = topTenant.getParentId();
            if (topTenantUri == "/" && topTenantParentId != null && topTenantParentId.equals("organizations")) {
                tenantIdsBetween.add(topTenantId);
            }
            return tenantIdsBetween;
        }
        return Collections.emptySet();
    }

    private void performObjectPermissionSave(ExecutionContext context, Resource resource, Object recipient, int permissionMask) {
        String auditEventType;
        ObjectPermission objectPermission;
        if (recipient == null) {
            throw new IllegalArgumentException("Recipient is null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Resource is null.");
        }
        List lstObjPerms = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(context, (Object)resource, recipient);
        if (lstObjPerms != null && lstObjPerms.size() > 0) {
            objectPermission = (ObjectPermission)lstObjPerms.get(0);
            auditEventType = "updatePermission";
        } else {
            objectPermission = this.objectPermissionService.newObjectPermission(context);
            auditEventType = "createPermission";
        }
        this.createAuditEvent(auditEventType);
        objectPermission.setURI(resource.getProtocol() + ":" + resource.getURIString());
        objectPermission.setPermissionMask(permissionMask);
        objectPermission.setPermissionRecipient(recipient);
        this.objectPermissionService.putObjectPermission(context, objectPermission);
        this.closeAuditEvent(auditEventType);
    }

    private void performObjectPermissionDelete(ExecutionContext context, Resource resource, Object recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("Recipient is null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Resource is null.");
        }
        List lstObjPerms = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(context, (Object)resource, recipient);
        if (lstObjPerms != null && lstObjPerms.size() > 0) {
            ObjectPermission objectPermission = (ObjectPermission)lstObjPerms.get(0);
            if (objectPermission == null || objectPermission.getPermissionRecipient() == null) {
                this.log.warn((Object)"No permission for target and recipient to delete.");
            } else {
                this.createAuditEvent("deletePermission");
                this.objectPermissionService.deleteObjectPermission(context, objectPermission);
                this.closeAuditEvent("deletePermission");
            }
        }
    }

    private List<User> extractUsers(Set<UserWithPermission> userWithPermissionSet) {
        ArrayList<User> users = new ArrayList<User>(userWithPermissionSet.size());
        for (UserWithPermission userWithPermission : userWithPermissionSet) {
            users.add(userWithPermission.getUser());
        }
        return users;
    }

    private List<Role> extractRoles(Set<RoleWithPermission> roleWithPermissionSet) {
        ArrayList<Role> roles = new ArrayList<Role>(roleWithPermissionSet.size());
        for (RoleWithPermission roleWithPermission : roleWithPermissionSet) {
            roles.add(roleWithPermission.getRole());
        }
        return roles;
    }

    public void setPermissionJSONHelper(PermissionJSONHelper permissionJSONHelper) {
        this.permissionJSONHelper = permissionJSONHelper;
    }

    public void setObjectPermissionService(ObjectPermissionService objectPermissionService) {
        this.objectPermissionService = objectPermissionService;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    protected ExecutionContext getExecutionContext(RequestContext context) {
        return JasperServerUtil.getExecutionContext((RequestContext)context);
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public void setRolesToDisablePermissionEditForEveryone(List<String> rolesToDisablePermissionEditForEveryone) {
        this.rolesToDisablePermissionEditForEveryone = rolesToDisablePermissionEditForEveryone;
    }

    public void setRolesToDisablePermissionEditForNonSuperuser(List<String> rolesToDisablePermissionEditForNonSuperuser) {
        this.rolesToDisablePermissionEditForNonSuperuser = rolesToDisablePermissionEditForNonSuperuser;
    }

    public void setRoleSuperuser(String roleSuperuser) {
        this.roleSuperuser = roleSuperuser;
    }

    public void setDefaultSuperuserUsername(String defaultSuperuserUsername) {
        this.defaultSuperuserUsername = defaultSuperuserUsername;
    }

    class State {
        private Map<String, ResourcePermissionsState> resourcePermissionsStateMap = new HashMap<String, ResourcePermissionsState>();

        State() {
        }

        public Map<String, ResourcePermissionsState> getResourcePermissionsStateMap() {
            return this.resourcePermissionsStateMap;
        }
    }

    class ResourcePermissionsState {
        private String resourceUri;
        private boolean isFolder = false;
        private ObjectType objectType = ObjectType.USER;
        private EntitiesListState entitiesListState = new EntitiesListState();
        private Resource resource;

        ResourcePermissionsState() {
        }

        public String getResourceUri() {
            return this.resourceUri;
        }

        public void setResourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
        }

        public boolean isFolder() {
            return this.isFolder;
        }

        public void setFolder(boolean folder) {
            this.isFolder = folder;
        }

        public ObjectType getObjectType() {
            return this.objectType;
        }

        public void setObjectType(ObjectType objectType) {
            this.objectType = objectType;
        }

        public EntitiesListState getEntitiesListState() {
            return this.entitiesListState;
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setResource(Resource resource) {
            this.resource = resource;
        }
    }

    static enum ObjectType {
        USER,
        ROLE;

    }
}

