/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.eval;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.LRUCache;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.query.QueryPlugin;

public final class TeiidScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private static Map<ClassLoader, Map<Class<?>, Map<String, Method>>> properties = new WeakHashMap(100);
    private static Pattern splitter = Pattern.compile("\\.");

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        final String[] parts = splitter.split(script);
        for (int i = 1; i < parts.length; ++i) {
            String string = parts[i];
            for (int j = 0; j < string.length(); ++j) {
                if (Character.isJavaIdentifierPart(string.charAt(j))) continue;
                throw new ScriptException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30431, new Object[]{string, Character.valueOf(string.charAt(j))}));
            }
        }
        return new CompiledScript(){

            @Override
            public ScriptEngine getEngine() {
                return TeiidScriptEngine.this;
            }

            @Override
            public Object eval(ScriptContext sc) throws ScriptException {
                if (sc == null) {
                    throw new NullPointerException();
                }
                Object obj = null;
                if (parts.length > 0) {
                    obj = sc.getAttribute(parts[0]);
                }
                if (obj == null) {
                    return null;
                }
                for (int i = 1; i < parts.length; ++i) {
                    String part = parts[i];
                    Map<String, Method> methodMap = TeiidScriptEngine.this.getMethodMap(obj.getClass());
                    Method m = methodMap.get(part);
                    if (m == null) {
                        throw new ScriptException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31111, new Object[]{part, obj.getClass()}));
                    }
                    try {
                        obj = m.invoke(obj, new Object[0]);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new ScriptException(e);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof Exception) {
                            throw new ScriptException((Exception)e.getCause());
                        }
                        throw new ScriptException(e);
                    }
                }
                return obj;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Method> getMethodMap(Class<?> clazz) throws ScriptException {
        Map<Class<Object>, Map<String, Method>> clazzMaps = null;
        Map<ClassLoader, Map<Class<?>, Map<String, Method>>> map = properties;
        synchronized (map) {
            clazzMaps = properties.get(clazz.getClassLoader());
            if (clazzMaps == null) {
                clazzMaps = Collections.synchronizedMap(new LRUCache(100));
                properties.put(clazz.getClassLoader(), clazzMaps);
            }
        }
        Map<String, Method> methodMap = clazzMaps.get(clazz);
        if (methodMap == null) {
            try {
                BeanInfo info = Introspector.getBeanInfo(clazz);
                PropertyDescriptor[] pds = info.getPropertyDescriptors();
                methodMap = new LinkedHashMap<String, Method>();
                if (pds != null) {
                    for (int j = 0; j < pds.length; ++j) {
                        PropertyDescriptor pd = pds[j];
                        if (pd.getReadMethod() == null || pd instanceof IndexedPropertyDescriptor) continue;
                        String name = pd.getName();
                        Method m = pd.getReadMethod();
                        methodMap.put(name, m);
                    }
                }
                MethodDescriptor[] mds = info.getMethodDescriptors();
                if (pds != null) {
                    for (int j = 0; j < mds.length; ++j) {
                        MethodDescriptor md = mds[j];
                        if (md.getMethod() == null || md.getMethod().getParameterTypes().length > 0 || md.getMethod().getReturnType() == Void.class) continue;
                        String name = md.getName();
                        Method m = md.getMethod();
                        methodMap.put(name, m);
                    }
                }
                clazzMaps.put(clazz, methodMap);
            }
            catch (IntrospectionException e) {
                throw new ScriptException(e);
            }
        }
        return methodMap;
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        try {
            return this.compile(ObjectConverterUtil.convertToString((Reader)script));
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public ScriptEngineFactory getFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object eval(Reader reader, ScriptContext sc) throws ScriptException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object eval(String script, ScriptContext sc) throws ScriptException {
        throw new UnsupportedOperationException();
    }
}

