/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Map;
import java.util.TreeMap;
import org.teiid.core.util.EquivalenceUtil;

public class SourceHint {
    private boolean useAliases;
    private String generalHint;
    private Map<String, SpecificHint> sourceHints;

    public String getGeneralHint() {
        return this.generalHint;
    }

    public void setGeneralHint(String generalHint) {
        this.generalHint = generalHint;
    }

    public void setSourceHint(String translatorName, String hint, boolean useAliases) {
        if (this.sourceHints == null) {
            this.sourceHints = new TreeMap<String, SpecificHint>(String.CASE_INSENSITIVE_ORDER);
        }
        this.sourceHints.put(translatorName, new SpecificHint(hint, useAliases));
    }

    public SpecificHint getSpecificHint(String sourceName) {
        if (this.sourceHints == null) {
            return null;
        }
        return this.sourceHints.get(sourceName);
    }

    public String getSourceHint(String sourceName) {
        SpecificHint sp = this.getSpecificHint(sourceName);
        if (sp != null) {
            return sp.getHint();
        }
        return null;
    }

    public Map<String, SpecificHint> getSpecificHints() {
        return this.sourceHints;
    }

    public boolean isUseAliases() {
        return this.useAliases;
    }

    public void setUseAliases(boolean useAliases) {
        this.useAliases = useAliases;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SourceHint)) {
            return false;
        }
        SourceHint other = (SourceHint)obj;
        return EquivalenceUtil.areEqual((Object)this.generalHint, (Object)other.generalHint) && EquivalenceUtil.areEqual(this.sourceHints, other.sourceHints);
    }

    public static class SpecificHint {
        String hint;
        boolean useAliases;

        public SpecificHint(String hint, boolean useAliases) {
            this.hint = hint;
            this.useAliases = useAliases;
        }

        public String getHint() {
            return this.hint;
        }

        public boolean isUseAliases() {
            return this.useAliases;
        }
    }
}

