/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.test.olap;

import com.tonbeller.jpivot.olap.model.Alignable;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.model.impl.PropertyImpl;
import com.tonbeller.jpivot.test.olap.TestDimension;
import com.tonbeller.jpivot.test.olap.TestHierarchy;
import com.tonbeller.jpivot.test.olap.TestMember;
import java.util.ArrayList;
import java.util.Iterator;

class PropertyBuilder {
    PropertyBuilder() {
    }

    void build(TestDimension dim) {
        TestHierarchy hier = (TestHierarchy)dim.getHierarchies()[0];
        TestMember[] roots = hier.getRootMembers();
        for (int i = 0; i < roots.length; ++i) {
            this.addProperties(roots[i], 0, i);
        }
    }

    private void addProperties(TestMember member, int level, int index) {
        ArrayList<PropertyImpl> pl = new ArrayList<PropertyImpl>();
        pl.add(new PropertyImpl("P", "" + (index == 1 ? 10000 : index), Alignable.Alignment.RIGHT));
        pl.add(new PropertyImpl("P" + level, "V" + level + index));
        if (level == 1) {
            pl.add(new PropertyImpl("link", "http://www.tonbeller.com"));
        }
        if (level == 2) {
            String[] arrows = new String[]{"down", "none", "up"};
            pl.add(new PropertyImpl("arrow", arrows[index % 3]));
            String[] styles = new String[]{"red", "yellow", "green"};
            pl.add(new PropertyImpl("style", styles[index % 3]));
            pl.add(new PropertyImpl("My Image.image", "/wcf/form/ok.png"));
            pl.add(new PropertyImpl("My Image.link", "http://www.tonbeller.com"));
        }
        if (level == 3) {
            pl.add(new PropertyImpl("MyLabel", "MyValue " + index));
            pl.add(new PropertyImpl("MyLabel.link", "http://jpivot.sourceforge.net"));
            pl.add(new PropertyImpl("MyLabel.arrow", "up"));
            pl.add(new PropertyImpl("MyLabel.image", "http://sourceforge.net/sflogo.php?group_id=58645&type=4"));
        }
        Property[] p = pl.toArray(new Property[0]);
        member.setProperties(p);
        index = 0;
        Iterator it = member.getChildMember().iterator();
        while (it.hasNext()) {
            this.addProperties((TestMember)it.next(), level + 1, index++);
        }
    }
}

