/*
 * Copyright (C) 2007 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
 
#ifndef jasperserver_marshaller_H
#define jasperserver_marshaller_H

#include "stringbuffer.h"
#include "repository.h"

/** \brief Create an xml string representing the request.
   
   This function transform a request structure into an xml.
   The xml is encoded in  UTF8 and is stored in the 'buffer' string.
   
   \param request a not null request
   \param buffer a not null jasperserver_string_t *

   \return the length of buffer or -1 if an error occurs.
*/
int jasperserver_request_marshal(jasperserver_request_t *request, jasperserver_string_t *buffer);


#endif
