/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.logutil;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;

public class IndentingPrintWriter
extends PrintWriter {
    private int level = 0;
    private int indentWidth = 4;
    private String indentString = "";

    public void printMsg(String msg, Object ... data) {
        StringTokenizer st = new StringTokenizer(msg, "@", true);
        StringBuffer result = new StringBuffer();
        String token = null;
        int pos = 0;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals("@")) {
                if (pos < data.length) {
                    result.append(data[pos]);
                    ++pos;
                    continue;
                }
                throw new Error("List too short for message");
            }
            result.append(token);
        }
        this.print(result);
        this.println();
    }

    public IndentingPrintWriter(Writer out) {
        super(out, true);
    }

    public IndentingPrintWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public IndentingPrintWriter(OutputStream out) {
        super(out, true);
    }

    public IndentingPrintWriter(OutputStream out, boolean autoFlush) {
        super((Writer)new BufferedWriter(new OutputStreamWriter(out)), autoFlush);
    }

    public void setIndentWidth(int indentWidth) {
        this.indentWidth = indentWidth;
        this.updateIndentString();
    }

    public void indent() {
        ++this.level;
        this.updateIndentString();
    }

    public void undent() {
        if (this.level > 0) {
            --this.level;
            this.updateIndentString();
        }
    }

    private void updateIndentString() {
        int size = this.level * this.indentWidth;
        StringBuffer sbuf = new StringBuffer(size);
        for (int ctr = 0; ctr < size; ++ctr) {
            sbuf.append(" ");
        }
        this.indentString = sbuf.toString();
    }

    @Override
    public void println() {
        super.println();
        this.print(this.indentString);
    }
}

