/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.marshalling.jboss.Marshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.web.infinispan.session.MutableDetector;
import org.wildfly.clustering.web.infinispan.session.SessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;

public class FineSessionAttributes<V>
extends FineImmutableSessionAttributes<V>
implements SessionAttributes {
    private final Cache<SessionAttributeKey, V> cache;
    private final Map<String, Mutator> mutations = new ConcurrentHashMap<String, Mutator>();
    private final Marshaller<Object, V, MarshallingContext> marshaller;
    private final CacheProperties properties;

    public FineSessionAttributes(String id, Cache<SessionAttributeKey, V> cache, Marshaller<Object, V, MarshallingContext> marshaller, CacheProperties properties) {
        super(id, cache, marshaller);
        this.cache = cache;
        this.marshaller = marshaller;
        this.properties = properties;
    }

    public Object removeAttribute(String name) {
        SessionAttributeKey key = this.createKey(name);
        Object result = this.read(name, this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove((Object)key));
        this.mutations.remove(name);
        return result;
    }

    public Object setAttribute(String name, Object attribute) {
        if (attribute == null) {
            return this.removeAttribute(name);
        }
        if (this.properties.isMarshalling() && !((MarshallingContext)this.marshaller.getContext()).isMarshallable(attribute)) {
            throw new IllegalArgumentException((Throwable)new NotSerializableException(attribute.getClass().getName()));
        }
        SessionAttributeKey key = this.createKey(name);
        Object value = this.marshaller.write(attribute);
        Object result = this.read(name, this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).put((Object)key, value));
        this.mutations.remove(name);
        return result;
    }

    @Override
    public Object getAttribute(String name) {
        SessionAttributeKey key = this.createKey(name);
        Object value = this.cache.get((Object)key);
        Object attribute = this.read(name, value);
        if (attribute != null && MutableDetector.isMutable(attribute)) {
            Mutator mutator = this.mutations.computeIfAbsent(name, k -> new CacheEntryMutator(this.cache, (Object)key, value));
            if (this.properties.isTransactional()) {
                mutator.mutate();
            }
        }
        return attribute;
    }

    @Override
    public void close() {
        if (!this.properties.isTransactional()) {
            this.mutations.values().forEach(mutator -> mutator.mutate());
        }
        this.mutations.clear();
    }
}

