/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.Map;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.workmanager.NamedDistributedWorkManager;
import org.jboss.as.connector.subsystems.jca.JcaCachedConnectionManagerDefinition;
import org.jboss.as.connector.subsystems.jca.JcaDistributedWorkManagerDefinition;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.connector.util.Injection;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.spi.workmanager.policy.Policy;
import org.jboss.jca.core.spi.workmanager.selector.Selector;
import org.jboss.jca.core.workmanager.policy.Always;
import org.jboss.jca.core.workmanager.policy.Never;
import org.jboss.jca.core.workmanager.policy.WaterMark;
import org.jboss.jca.core.workmanager.selector.FirstAvailable;
import org.jboss.jca.core.workmanager.selector.MaxFreeThreads;
import org.jboss.jca.core.workmanager.selector.PingTime;

public class JcaDistributedWorkManagerWriteHandler
extends AbstractWriteAttributeHandler<JcaSubsystemConfiguration> {
    static JcaDistributedWorkManagerWriteHandler INSTANCE = new JcaDistributedWorkManagerWriteHandler();

    private JcaDistributedWorkManagerWriteHandler() {
        super(JcaDistributedWorkManagerDefinition.DWmParameters.getAttributeDefinitions());
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<JcaSubsystemConfiguration> jcaSubsystemConfigurationHandbackHolder) throws OperationFailedException {
        block18: {
            Injection injector;
            NamedDistributedWorkManager namedDistributedWorkManager;
            block20: {
                block19: {
                    block17: {
                        ModelNode address = operation.require("address");
                        String name = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
                        Object wm = context.getServiceRegistry(true).getService(ConnectorServices.WORKMANAGER_SERVICE.append(new String[]{name})).getValue();
                        if (wm == null || !(wm instanceof NamedDistributedWorkManager)) {
                            throw ConnectorLogger.ROOT_LOGGER.failedToFindDistributedWorkManager(name);
                        }
                        namedDistributedWorkManager = (NamedDistributedWorkManager)((Object)wm);
                        injector = new Injection();
                        if (!attributeName.equals(JcaDistributedWorkManagerDefinition.DWmParameters.POLICY.getAttribute().getName())) break block17;
                        switch (JcaDistributedWorkManagerDefinition.PolicyValue.valueOf(resolvedValue.asString())) {
                            case NEVER: {
                                namedDistributedWorkManager.setPolicy((Policy)new Never());
                                break block18;
                            }
                            case ALWAYS: {
                                namedDistributedWorkManager.setPolicy((Policy)new Always());
                                break block18;
                            }
                            case WATERMARK: {
                                namedDistributedWorkManager.setPolicy((Policy)new WaterMark());
                                break block18;
                            }
                            default: {
                                throw ConnectorLogger.ROOT_LOGGER.unsupportedPolicy(resolvedValue.asString());
                            }
                        }
                    }
                    if (!attributeName.equals(JcaDistributedWorkManagerDefinition.DWmParameters.SELECTOR.getAttribute().getName())) break block19;
                    switch (JcaDistributedWorkManagerDefinition.SelectorValue.valueOf(resolvedValue.asString())) {
                        case FIRST_AVAILABLE: {
                            namedDistributedWorkManager.setSelector((Selector)new FirstAvailable());
                            break block18;
                        }
                        case MAX_FREE_THREADS: {
                            namedDistributedWorkManager.setSelector((Selector)new MaxFreeThreads());
                            break block18;
                        }
                        case PING_TIME: {
                            namedDistributedWorkManager.setSelector((Selector)new PingTime());
                            break block18;
                        }
                        default: {
                            throw ConnectorLogger.ROOT_LOGGER.unsupportedSelector(resolvedValue.asString());
                        }
                    }
                }
                if (!attributeName.equals(JcaDistributedWorkManagerDefinition.DWmParameters.POLICY_OPTIONS.getAttribute().getName()) || namedDistributedWorkManager.getPolicy() == null) break block20;
                for (Map.Entry entry : ((PropertiesAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.POLICY_OPTIONS.getAttribute()).unwrap((ExpressionResolver)context, operation).entrySet()) {
                    try {
                        injector.inject(namedDistributedWorkManager.getPolicy(), (String)entry.getKey(), entry.getValue());
                    }
                    catch (Exception e) {
                        ConnectorLogger.ROOT_LOGGER.unsupportedPolicyOption((String)entry.getKey());
                    }
                }
                break block18;
            }
            if (!attributeName.equals(JcaDistributedWorkManagerDefinition.DWmParameters.SELECTOR_OPTIONS.getAttribute().getName())) break block18;
            for (Map.Entry entry : ((PropertiesAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.SELECTOR_OPTIONS.getAttribute()).unwrap((ExpressionResolver)context, operation).entrySet()) {
                try {
                    injector.inject(namedDistributedWorkManager.getSelector(), (String)entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    ConnectorLogger.ROOT_LOGGER.unsupportedSelectorOption((String)entry.getKey());
                }
            }
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, JcaSubsystemConfiguration handback) throws OperationFailedException {
        CachedConnectionManager ccm = (CachedConnectionManager)context.getServiceRegistry(true).getService(ConnectorServices.CCM_SERVICE).getValue();
        if (attributeName.equals(JcaCachedConnectionManagerDefinition.CcmParameters.DEBUG.getAttribute().getName())) {
            ccm.setDebug(valueToRestore.asBoolean());
        } else if (attributeName.equals(JcaCachedConnectionManagerDefinition.CcmParameters.ERROR.getAttribute().getName())) {
            ccm.setError(valueToRestore.asBoolean());
        } else if (attributeName.equals(JcaCachedConnectionManagerDefinition.CcmParameters.IGNORE_UNKNOWN_CONNECTIONS.getAttribute().getName())) {
            ccm.setIgnoreUnknownConnections(valueToRestore.asBoolean());
        }
    }
}

