/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.security.impl.InMemorySingleSignOnManager;
import io.undertow.security.impl.SingleSignOnManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.SingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnService;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.security.sso.DistributableSingleSignOnManagerBuilder;

class SingleSignOnAdd
extends AbstractAddStepHandler {
    SingleSignOnAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition def : SingleSignOnDefinition.ATTRIBUTES) {
            def.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress hostAddress = address.subAddress(0, address.size() - 1);
        PathAddress serverAddress = hostAddress.subAddress(0, hostAddress.size() - 1);
        ModelNode domainModelNode = SingleSignOnDefinition.DOMAIN.resolveModelAttribute(context, model);
        ModelNode pathNode = SingleSignOnDefinition.PATH.resolveModelAttribute(context, model);
        String domain = domainModelNode.isDefined() ? domainModelNode.asString() : null;
        String path = pathNode.isDefined() ? pathNode.asString() : null;
        boolean secure = SingleSignOnDefinition.SECURE.resolveModelAttribute(context, model).asBoolean();
        boolean httpOnly = SingleSignOnDefinition.HTTP_ONLY.resolveModelAttribute(context, model).asBoolean();
        String cookieName = SingleSignOnDefinition.COOKIE_NAME.resolveModelAttribute(context, model).asString();
        String serverName = serverAddress.getLastElement().getValue();
        String hostName = hostAddress.getLastElement().getValue();
        ServiceName serviceName = UndertowService.ssoServiceName(serverName, hostName);
        ServiceName virtualHostServiceName = UndertowService.virtualHostName(serverName, hostName);
        ServiceTarget target = context.getServiceTarget();
        ServiceName managerServiceName = serviceName.append(new String[]{"manager"});
        if (DistributableSingleSignOnManagerBuilder.INSTANCE.isPresent()) {
            DistributableSingleSignOnManagerBuilder builder = DistributableSingleSignOnManagerBuilder.INSTANCE.get();
            builder.build(target, managerServiceName, serverName, hostName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        } else {
            target.addService(managerServiceName, (Service)new ValueService((Value)new ImmediateValue((Object)new InMemorySingleSignOnManager()))).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
        SingleSignOnService service = new SingleSignOnService(domain, path, httpOnly, secure, cookieName);
        target.addService(serviceName, (Service)service).addDependency(virtualHostServiceName, Host.class, service.getHost()).addDependency(managerServiceName, SingleSignOnManager.class, service.getSingleSignOnSessionManager()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

