/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionIdGenerator;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.extension.undertow.Host;

public class SessionIdGeneratorBuilder
implements Builder<SessionIdGenerator>,
Value<SessionIdGenerator> {
    private final InjectedValue<Host> host = new InjectedValue();
    private final ServiceName hostServiceName;

    public SessionIdGeneratorBuilder(ServiceName hostServiceName) {
        this.hostServiceName = hostServiceName;
    }

    public ServiceName getServiceName() {
        return this.hostServiceName.append(new String[]{"generator"});
    }

    public ServiceBuilder<SessionIdGenerator> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(this.hostServiceName, Host.class, this.host);
    }

    public SessionIdGenerator getValue() {
        SecureRandomSessionIdGenerator generator = new SecureRandomSessionIdGenerator();
        generator.setLength(((Host)this.host.getValue()).getServer().getServletContainer().getSessionIdLength());
        return generator;
    }
}

