/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.util.List;
import javax.batch.api.listener.JobListener;
import javax.batch.runtime.BatchStatus;
import org.jberet._private.BatchLogger;
import org.jberet.creation.JobScopedContextImpl;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.Listeners;
import org.jberet.job.model.RefArtifact;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.spi.JobTask;

public final class JobExecutionRunner
extends CompositeExecutionRunner<JobContextImpl>
implements JobTask {
    private final Job job;

    public JobExecutionRunner(JobContextImpl jobContext) {
        super(jobContext, null);
        this.job = jobContext.getJob();
    }

    @Override
    protected List<? extends JobElement> getJobElements() {
        return this.job.getJobElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int i;
        JobExecutionImpl jobExecution = ((JobContextImpl)this.batchContext).getJobExecution();
        if (jobExecution.getBatchStatus() != BatchStatus.STOPPING) {
            jobExecution.setBatchStatus(BatchStatus.STARTED);
            ((JobContextImpl)this.batchContext).getJobRepository().updateJobExecution(jobExecution, false, false);
        }
        Object[] jobListeners = null;
        try {
            jobListeners = this.createJobListeners();
            for (i = 0; i < jobListeners.length; ++i) {
                jobListeners[i].beforeJob();
            }
            this.runFromHeadOrRestartPoint(jobExecution.getRestartPosition());
            if (jobExecution.getBatchStatus() == BatchStatus.STARTED) {
                jobExecution.setBatchStatus(BatchStatus.COMPLETED);
            }
        }
        catch (Throwable e) {
            BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", this.job);
            jobExecution.setBatchStatus(BatchStatus.FAILED);
            if (jobListeners == null) {
                jobExecution.setExitStatus(e.toString());
            }
        }
        finally {
            if (jobListeners != null && jobListeners.length > 0) {
                for (i = 0; i < jobListeners.length; ++i) {
                    try {
                        jobListeners[i].afterJob();
                        continue;
                    }
                    catch (Throwable e) {
                        BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", jobListeners[i]);
                        jobExecution.setBatchStatus(BatchStatus.FAILED);
                    }
                }
                ((JobContextImpl)this.batchContext).destroyArtifact(jobListeners);
            }
        }
        boolean saveJobParameters = false;
        switch (jobExecution.getBatchStatus()) {
            case COMPLETED: {
                break;
            }
            case STARTED: {
                jobExecution.setBatchStatus(BatchStatus.COMPLETED);
                break;
            }
            case STOPPING: {
                jobExecution.setBatchStatus(BatchStatus.STOPPED);
            }
            case FAILED: 
            case STOPPED: {
                saveJobParameters = this.adjustRestartFailedOrStopped(jobExecution);
            }
        }
        ((JobContextImpl)this.batchContext).getJobRepository().updateJobExecution(jobExecution, true, saveJobParameters);
        ((JobContextImpl)this.batchContext).setTransientUserData(null);
        JobScopedContextImpl.ScopedInstance.destroy(((JobContextImpl)this.batchContext).getScopedBeans());
        jobExecution.cleanUp();
    }

    private boolean adjustRestartFailedOrStopped(JobExecutionImpl jobExecution) {
        if (!this.job.getRestartableBoolean()) {
            jobExecution.setRestartPosition("jberet.unrestartable");
        }
        if (this.job.getJobXmlName() != null) {
            jobExecution.addJobParameter("jberet.jobXmlName", this.job.getJobXmlName());
            return true;
        }
        return false;
    }

    private JobListener[] createJobListeners() {
        Listeners listeners = this.job.getListeners();
        if (listeners != null) {
            List<RefArtifact> listenerList = listeners.getListeners();
            int count = listenerList.size();
            JobListener[] jobListeners = new JobListener[count];
            for (int i = 0; i < count; ++i) {
                RefArtifact listener = listenerList.get(i);
                jobListeners[i] = (JobListener)((JobContextImpl)this.batchContext).createArtifact(listener.getRef(), null, listener.getProperties(), new StepContextImpl[0]);
            }
            return jobListeners;
        }
        return new JobListener[0];
    }

    @Override
    public int getRequiredRemainingPermits() {
        return 2;
    }
}

