/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.util.concurrent.locks.DeadlockChecker;
import org.infinispan.util.concurrent.locks.KeyAwareLockPromise;
import org.infinispan.util.concurrent.locks.impl.DefaultLockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="DeadlockDetectingLockManager", description="Information about the number of deadlocks that were detected")
public class DeadlockDetectingLockManager
extends DefaultLockManager
implements DeadlockChecker,
Runnable {
    private static final Log log = LogFactory.getLog(DeadlockDetectingLockManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private ScheduledFuture<?> scheduledFuture;
    protected volatile boolean exposeJmxStats;
    private AtomicLong localTxStopped = new AtomicLong(0L);
    private AtomicLong remoteTxStopped = new AtomicLong(0L);
    private AtomicLong cannotRunDld = new AtomicLong(0L);

    @Start
    public void init() {
        long spinDuration = this.configuration.deadlockDetection().spinDuration();
        this.exposeJmxStats = this.configuration.jmxStatistics().enabled();
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(this, spinDuration, spinDuration, TimeUnit.MILLISECONDS);
    }

    @Stop
    public void stopScheduler() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    @Override
    public KeyAwareLockPromise lock(Object key, Object lockOwner, long time, TimeUnit unit) {
        if (lockOwner instanceof DldGlobalTransaction) {
            ((DldGlobalTransaction)lockOwner).setLockIntention(Collections.singleton(key));
            return super.lock(key, lockOwner, time, unit);
        }
        return super.lock(key, lockOwner, time, unit);
    }

    @Override
    public KeyAwareLockPromise lockAll(Collection<?> keys, Object lockOwner, long time, TimeUnit unit) {
        if (lockOwner instanceof DldGlobalTransaction) {
            ((DldGlobalTransaction)lockOwner).setLockIntention(new HashSet<Object>(keys));
            return super.lockAll(keys, lockOwner, time, unit);
        }
        return super.lockAll(keys, lockOwner, time, unit);
    }

    @Override
    public void run() {
        this.lockContainer.deadlockCheck(this);
    }

    private boolean isDeadlockAndIAmLoosing(DldGlobalTransaction lockOwnerTx, DldGlobalTransaction thisTx) {
        boolean wouldWeLoose = thisTx.wouldLose(lockOwnerTx);
        if (!wouldWeLoose) {
            if (trace) {
                log.tracef("We (%s) win against the other (%s) transaction, so no point running rest of DLD", thisTx, lockOwnerTx);
            }
            return false;
        }
        return this.ownsAnyLocalIntention(thisTx, lockOwnerTx) || this.ownsRemoteIntention(lockOwnerTx, thisTx) || this.isSameKeyDeadlock(thisTx, lockOwnerTx);
    }

    private boolean isSameKeyDeadlock(DldGlobalTransaction thisTx, DldGlobalTransaction lockOwnerTx) {
        boolean iHaveRemoteLock = !thisTx.isRemote();
        boolean otherHasLocalLock = lockOwnerTx.isRemote();
        if (iHaveRemoteLock && otherHasLocalLock) {
            if (trace) {
                log.tracef("Same key deadlock between %s and %s.", thisTx, lockOwnerTx);
            }
            return true;
        }
        return false;
    }

    private boolean ownsRemoteIntention(DldGlobalTransaction lockOwnerTx, DldGlobalTransaction thisTx) {
        boolean localLockOwner;
        boolean bl = localLockOwner = !lockOwnerTx.isRemote();
        if (localLockOwner) {
            if (thisTx.hasAnyLockAtOrigin(lockOwnerTx)) {
                if (trace) {
                    log.trace("Same key deadlock detected: lock owner tries to acquire a lock remotely but we have it!");
                }
                return true;
            }
        } else if (trace) {
            log.tracef("Lock owner is remote: %s", lockOwnerTx);
        }
        return false;
    }

    private boolean ownsAnyLocalIntention(DldGlobalTransaction thisTx, DldGlobalTransaction otherTx) {
        for (Object key : otherTx.getLockIntention()) {
            if (!this.ownsLock(key, thisTx)) continue;
            if (trace) {
                log.tracef("Local intention is '%s' and we (%s) own the lock.", key, thisTx);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean deadlockDetected(Object pendingOwner, Object currentOwner) {
        DldGlobalTransaction pendingTx;
        DldGlobalTransaction ownerTx;
        if (!(pendingOwner instanceof DldGlobalTransaction) || !(currentOwner instanceof DldGlobalTransaction)) {
            if (trace) {
                log.tracef("Unable to run DLD with %s and %s. One of them are not a DldGlobalTransaction.", pendingOwner, currentOwner);
            }
            this.cannotRunDld.incrementAndGet();
            return false;
        }
        if (trace) {
            log.tracef("Could not acquire lock. It is locked by %s (%s)", currentOwner, System.identityHashCode(currentOwner));
        }
        if (this.isDeadlockAndIAmLoosing(ownerTx = (DldGlobalTransaction)currentOwner, pendingTx = (DldGlobalTransaction)pendingOwner)) {
            this.updateStats(pendingTx);
            log.tracef("Deadlock found and we (%s) shall not continue. Other tx is %s", pendingOwner, currentOwner);
            return true;
        }
        return false;
    }

    public void setExposeJmxStats(boolean exposeJmxStats) {
        this.exposeJmxStats = exposeJmxStats;
    }

    @ManagedAttribute(description="Total number of local detected deadlocks", displayName="Number of total detected deadlocks", measurementType=MeasurementType.TRENDSUP)
    public long getTotalNumberOfDetectedDeadlocks() {
        return this.localTxStopped.get() + this.remoteTxStopped.get();
    }

    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.localTxStopped.set(0L);
        this.remoteTxStopped.set(0L);
        this.cannotRunDld.set(0L);
    }

    @ManagedAttribute(description="Number of remote transactions that were rolled-back due to deadlocks", displayName="Number of remote transaction that were roll backed due to deadlocks", measurementType=MeasurementType.TRENDSUP)
    public long getDetectedRemoteDeadlocks() {
        return this.remoteTxStopped.get();
    }

    @ManagedAttribute(description="Number of local transactions that were rolled-back due to deadlocks", displayName="Number of local transaction that were roll backed due to deadlocks", measurementType=MeasurementType.TRENDSUP)
    public long getDetectedLocalDeadlocks() {
        return this.localTxStopped.get();
    }

    @ManagedAttribute(description="Number of situations when we try to determine a deadlock and the other lock owner is NOT a transaction. In this scenario we cannot run the deadlock detection mechanism", displayName="Number of unsolvable deadlock situations", measurementType=MeasurementType.TRENDSUP)
    public long getOverlapWithNotDeadlockAwareLockOwners() {
        return this.cannotRunDld.get();
    }

    private void updateStats(DldGlobalTransaction tx) {
        if (this.exposeJmxStats) {
            if (tx.isRemote()) {
                this.remoteTxStopped.incrementAndGet();
            } else {
                this.localTxStopped.incrementAndGet();
            }
        }
    }
}

