/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.WSDLElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SOAPBindingUtil;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapBody;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapFault;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapHeader;
import org.apache.cxf.common.util.CollectionUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.validator.internal.AbstractDefinitionValidator;
import org.apache.cxf.wsdl.WSDLHelper;

public class WSIBPValidator
extends AbstractDefinitionValidator {
    private List<String> operationMap = new ArrayList<String>();
    private WSDLHelper wsdlHelper = new WSDLHelper();

    public WSIBPValidator(Definition def) {
        super(def);
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        for (Method m : this.getClass().getMethods()) {
            if (!m.getName().startsWith("check") || m.getGenericReturnType() != Boolean.TYPE || m.getGenericParameterTypes().length != 0) continue;
            try {
                Boolean res = (Boolean)m.invoke((Object)this, new Object[0]);
                if (res.booleanValue()) continue;
                valid = false;
            }
            catch (Exception e) {
                throw new ToolException((Throwable)e);
            }
        }
        return valid;
    }

    private boolean checkR2716(BindingOperation bop) {
        SoapBody inSoapBody = SOAPBindingUtil.getBindingInputSOAPBody((BindingOperation)bop);
        SoapBody outSoapBody = SOAPBindingUtil.getBindingOutputSOAPBody((BindingOperation)bop);
        if (inSoapBody != null && !StringUtils.isEmpty((String)inSoapBody.getNamespaceURI()) || outSoapBody != null && !StringUtils.isEmpty((String)outSoapBody.getNamespaceURI())) {
            this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2716") + "Operation '" + bop.getName() + "' soapBody MUST NOT have namespace attribute");
            return false;
        }
        SoapHeader inSoapHeader = SOAPBindingUtil.getBindingInputSOAPHeader((BindingOperation)bop);
        SoapHeader outSoapHeader = SOAPBindingUtil.getBindingOutputSOAPHeader((BindingOperation)bop);
        if (inSoapHeader != null && !StringUtils.isEmpty((String)inSoapHeader.getNamespaceURI()) || outSoapHeader != null && !StringUtils.isEmpty((String)outSoapHeader.getNamespaceURI())) {
            this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2716") + "Operation '" + bop.getName() + "' soapHeader MUST NOT have namespace attribute");
            return false;
        }
        List soapFaults = SOAPBindingUtil.getBindingOperationSoapFaults((BindingOperation)bop);
        for (SoapFault fault : soapFaults) {
            if (StringUtils.isEmpty((String)fault.getNamespaceURI())) continue;
            this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2716") + "Operation '" + bop.getName() + "' soapFault MUST NOT have namespace attribute");
            return false;
        }
        return true;
    }

    private boolean checkR2717AndR2726(BindingOperation bop) {
        if (null == bop) {
            return true;
        }
        SoapBody inSoapBody = SOAPBindingUtil.getBindingInputSOAPBody((BindingOperation)bop);
        SoapBody outSoapBody = SOAPBindingUtil.getBindingOutputSOAPBody((BindingOperation)bop);
        if (inSoapBody != null && StringUtils.isEmpty((String)inSoapBody.getNamespaceURI()) || outSoapBody != null && StringUtils.isEmpty((String)outSoapBody.getNamespaceURI())) {
            this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2717") + "soapBody in the input/output of the binding operation '" + bop.getName() + "' MUST have namespace attribute");
            return false;
        }
        SoapHeader inSoapHeader = SOAPBindingUtil.getBindingInputSOAPHeader((BindingOperation)bop);
        SoapHeader outSoapHeader = SOAPBindingUtil.getBindingOutputSOAPHeader((BindingOperation)bop);
        if (inSoapHeader != null && !StringUtils.isEmpty((String)inSoapHeader.getNamespaceURI()) || outSoapHeader != null && !StringUtils.isEmpty((String)outSoapHeader.getNamespaceURI())) {
            this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2726") + "Operation '" + bop.getName() + "' soapHeader MUST NOT have namespace attribute");
            return false;
        }
        List soapFaults = SOAPBindingUtil.getBindingOperationSoapFaults((BindingOperation)bop);
        for (SoapFault fault : soapFaults) {
            if (StringUtils.isEmpty((String)fault.getNamespaceURI())) continue;
            this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2726") + "Operation '" + bop.getName() + "' soapFault MUST NOT have namespace attribute");
            return false;
        }
        return true;
    }

    private boolean checkR2201Input(Operation operation, BindingOperation bop) {
        List partsList = this.wsdlHelper.getInMessageParts(operation);
        int inmessagePartsCount = partsList.size();
        SoapBody soapBody = SOAPBindingUtil.getBindingInputSOAPBody((BindingOperation)bop);
        if (soapBody != null) {
            List parts = soapBody.getParts();
            int boundPartSize = parts == null ? inmessagePartsCount : parts.size();
            SoapHeader soapHeader = SOAPBindingUtil.getBindingInputSOAPHeader((BindingOperation)bop);
            int n = boundPartSize = soapHeader != null && soapHeader.getMessage().equals(operation.getInput().getMessage().getQName()) ? boundPartSize - 1 : boundPartSize;
            if (parts != null) {
                for (String partName : parts) {
                    boolean isDefined = false;
                    for (Part part : partsList) {
                        if (!partName.equalsIgnoreCase(part.getName())) continue;
                        isDefined = true;
                        break;
                    }
                    if (isDefined) continue;
                    this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2201") + "Operation '" + operation.getName() + "' soapBody parts : " + partName + " not found in the message, wrong WSDL");
                    return false;
                }
            } else if (partsList.size() > 1) {
                this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2210") + "Operation '" + operation.getName() + "' more than one part bound to body");
                return false;
            }
            if (boundPartSize > 1) {
                this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2201") + "Operation '" + operation.getName() + "' more than one part bound to body");
                return false;
            }
        }
        return true;
    }

    private boolean checkR2201Output(Operation operation, BindingOperation bop) {
        int outmessagePartsCount = this.wsdlHelper.getOutMessageParts(operation).size();
        SoapBody soapBody = SOAPBindingUtil.getBindingOutputSOAPBody((BindingOperation)bop);
        if (soapBody != null) {
            List parts = soapBody.getParts();
            int boundPartSize = parts == null ? outmessagePartsCount : parts.size();
            SoapHeader soapHeader = SOAPBindingUtil.getBindingOutputSOAPHeader((BindingOperation)bop);
            int n = boundPartSize = soapHeader != null && soapHeader.getMessage().equals(operation.getOutput().getMessage().getQName()) ? boundPartSize - 1 : boundPartSize;
            if (parts != null) {
                for (String partName : parts) {
                    boolean isDefined = false;
                    for (Part part : this.wsdlHelper.getOutMessageParts(operation)) {
                        if (!partName.equalsIgnoreCase(part.getName())) continue;
                        isDefined = true;
                        break;
                    }
                    if (isDefined) continue;
                    this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2201") + "Operation '" + operation.getName() + "' soapBody parts : " + partName + " not found in the message, wrong WSDL");
                    return false;
                }
            } else if (this.wsdlHelper.getOutMessageParts(operation).size() > 1) {
                this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2210") + "Operation '" + operation.getName() + "' more than one part bound to body");
                return false;
            }
            if (boundPartSize > 1) {
                this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2201") + "Operation '" + operation.getName() + "' more than one part bound to body");
                return false;
            }
        }
        return true;
    }

    private boolean checkR2209(Operation operation, BindingOperation bop) {
        if (bop.getBindingInput() == null && operation.getInput() != null || bop.getBindingOutput() == null && operation.getOutput() != null) {
            this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2209") + "Unbound PortType elements in Operation '" + operation.getName() + "'");
            return false;
        }
        return true;
    }

    public boolean checkBinding() {
        for (PortType portType : this.wsdlHelper.getPortTypes(this.def)) {
            for (Operation operation : portType.getOperations()) {
                boolean passed;
                String style;
                if (this.isOverloading(operation.getName())) continue;
                BindingOperation bop = this.wsdlHelper.getBindingOperation(this.def, operation.getName());
                if (bop == null) {
                    this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2718") + "A wsdl:binding in a DESCRIPTION MUST have the same set of " + "wsdl:operations as the wsdl:portType to which it refers. " + operation.getName() + " not found in wsdl:binding.");
                    return false;
                }
                Binding binding = this.wsdlHelper.getBinding(bop, this.def);
                String bindingStyle = binding != null ? SOAPBindingUtil.getBindingStyle((Binding)binding) : "";
                String string = style = StringUtils.isEmpty((String)SOAPBindingUtil.getSOAPOperationStyle((BindingOperation)bop)) ? bindingStyle : SOAPBindingUtil.getSOAPOperationStyle((BindingOperation)bop);
                if (!("DOCUMENT".equalsIgnoreCase(style) || StringUtils.isEmpty((String)style) ? !(passed = this.checkR2201Input(operation, bop) && this.checkR2201Output(operation, bop) && this.checkR2209(operation, bop) && this.checkR2716(bop)) : !this.checkR2717AndR2726(bop))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isHeaderPart(BindingOperation bop, Part part) {
        QName elementName = part.getElementName();
        if (elementName != null) {
            String partName = elementName.getLocalPart();
            SoapHeader inSoapHeader = SOAPBindingUtil.getBindingInputSOAPHeader((BindingOperation)bop);
            if (inSoapHeader != null) {
                return partName.equals(inSoapHeader.getPart());
            }
            SoapHeader outSoapHeader = SOAPBindingUtil.getBindingOutputSOAPHeader((BindingOperation)bop);
            if (outSoapHeader != null) {
                return partName.equals(outSoapHeader.getPart());
            }
        }
        return false;
    }

    public boolean checkR2203And2204() {
        Collection bindings = CastUtils.cast(this.def.getBindings().values());
        for (Binding binding : bindings) {
            String style = SOAPBindingUtil.getCanonicalBindingStyle((Binding)binding);
            if (binding.getPortType() == null) {
                return true;
            }
            for (Operation operation : binding.getPortType().getOperations()) {
                Set<String> ignorableParts;
                BindingOperation bop = this.wsdlHelper.getBindingOperation(this.def, operation.getName());
                if (operation.getInput() != null && operation.getInput().getMessage() != null) {
                    Message inMess = operation.getInput().getMessage();
                    ignorableParts = WSIBPValidator.getIgnorableParts((WSDLElement)bop.getBindingInput());
                    for (Part p : inMess.getParts().values()) {
                        if (SOAPBinding.Style.RPC.name().equalsIgnoreCase(style) && p.getTypeName() == null && !this.isHeaderPart(bop, p) && !WSIBPValidator.isIgnorablePart(p.getName(), ignorableParts)) {
                            this.addErrorMessage("An rpc-literal binding in a DESCRIPTION MUST refer, in its soapbind:body element(s), only to wsdl:part element(s) that have been defined using the type attribute.");
                            return false;
                        }
                        if (!SOAPBinding.Style.DOCUMENT.name().equalsIgnoreCase(style) || p.getElementName() != null || WSIBPValidator.isIgnorablePart(p.getName(), ignorableParts)) continue;
                        this.addErrorMessage("A document-literal binding in a DESCRIPTION MUST refer, in each of its soapbind:body element(s),only to wsdl:part element(s) that have been defined using the element attribute.");
                        return false;
                    }
                }
                if (operation.getOutput() == null || operation.getOutput().getMessage() == null) continue;
                Message outMess = operation.getOutput().getMessage();
                ignorableParts = WSIBPValidator.getIgnorableParts((WSDLElement)bop.getBindingOutput());
                for (Part p : outMess.getParts().values()) {
                    if (style.equalsIgnoreCase(SOAPBinding.Style.RPC.name()) && p.getTypeName() == null && !this.isHeaderPart(bop, p) && !WSIBPValidator.isIgnorablePart(p.getName(), ignorableParts)) {
                        this.addErrorMessage("An rpc-literal binding in a DESCRIPTION MUST refer, in its soapbind:body element(s), only to wsdl:part element(s) that have been defined using the type attribute.");
                        return false;
                    }
                    if (!style.equalsIgnoreCase(SOAPBinding.Style.DOCUMENT.name()) || p.getElementName() != null || WSIBPValidator.isIgnorablePart(p.getName(), ignorableParts)) continue;
                    this.addErrorMessage("A document-literal binding in a DESCRIPTION MUST refer, in each of its soapbind:body element(s),only to wsdl:part element(s) that have been defined using the element attribute.");
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isIgnorablePart(String name, Set<String> ignorableParts) {
        return ignorableParts != null && ignorableParts.contains(name);
    }

    private static Set<String> getIgnorableParts(WSDLElement ext) {
        HashSet<String> parts = null;
        if (ext != null && ext.getExtensibilityElements() != null && ext.getExtensibilityElements().size() > 0 && ext.getExtensibilityElements().get(0) instanceof MIMEMultipartRelated) {
            MIMEMultipartRelated mpr = (MIMEMultipartRelated)ext.getExtensibilityElements().get(0);
            List mps = CastUtils.cast((List)mpr.getMIMEParts());
            parts = new HashSet<String>(mps.size());
            for (MIMEPart mp : mps) {
                if (mp.getExtensibilityElements() == null || mp.getExtensibilityElements().size() <= 0 || !(mp.getExtensibilityElements().get(0) instanceof MIMEContent)) continue;
                parts.add(((MIMEContent)mp.getExtensibilityElements().get(0)).getPart());
            }
        }
        return parts;
    }

    public boolean checkR2205() {
        Collection bindings = CastUtils.cast(this.def.getBindings().values());
        for (Binding binding : bindings) {
            if (!SOAPBindingUtil.isSOAPBinding((Binding)binding)) {
                System.err.println("WSIBP Validator found <" + binding.getQName() + "> is NOT a SOAP binding");
                continue;
            }
            if (binding.getPortType() == null) continue;
            for (Operation operation : binding.getPortType().getOperations()) {
                Collection faults = CastUtils.cast(operation.getFaults().values());
                if (CollectionUtils.isEmpty((Collection)faults)) continue;
                for (Fault fault : faults) {
                    Message message = fault.getMessage();
                    Collection parts = CastUtils.cast(message.getParts().values());
                    for (Part part : parts) {
                        if (part.getElementName() != null) continue;
                        this.addErrorMessage(WSIBPValidator.getErrorPrefix("WSI-BP-1.0 R2205") + "In Message " + message.getQName() + ", part " + part.getName() + " must specify a 'element' attribute");
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean checkR2705() {
        Collection bindings = CastUtils.cast(this.def.getBindings().values());
        for (Binding binding : bindings) {
            if (!SOAPBindingUtil.isMixedStyle((Binding)binding)) continue;
            this.addErrorMessage("Mixed style, invalid WSDL");
            return false;
        }
        return true;
    }

    private boolean isOverloading(String operationName) {
        if (this.operationMap.contains(operationName)) {
            return true;
        }
        this.operationMap.add(operationName);
        return false;
    }

    private static String getErrorPrefix(String ruleBroken) {
        return ruleBroken + " violation: ";
    }
}

