/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.instrumentation;

import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToStringHelper {
    private static final String ARRAY_PREFIX = "[";
    private static final String ARRAY_SUFFIX = "]";
    private static final String ELEMENT_SEPARATOR = ", ";
    static final Map<Class<?>, Object> unrenderableClasses = new WeakHashMap();

    public static String render(Object o) {
        if (o == null) {
            return String.valueOf(o);
        }
        Class<?> objectClass = o.getClass();
        if (!unrenderableClasses.containsKey(objectClass)) {
            try {
                if (objectClass.isArray()) {
                    return ToStringHelper.renderArray(o, objectClass).toString();
                }
                return o.toString();
            }
            catch (Exception e) {
                Long now = new Long(System.currentTimeMillis());
                System.err.println("Disabling exception throwing class " + objectClass.getName() + ELEMENT_SEPARATOR + e.getMessage());
                unrenderableClasses.put(objectClass, now);
            }
        }
        String name = o.getClass().getName();
        return name + "@" + Integer.toHexString(o.hashCode());
    }

    private static StringBuffer renderArray(Object o, Class<?> objectClass) {
        Class<?> componentType = objectClass.getComponentType();
        StringBuffer sb = new StringBuffer(ARRAY_PREFIX);
        if (!componentType.isPrimitive()) {
            Object[] oa = (Object[])o;
            for (int i = 0; i < oa.length; ++i) {
                if (i > 0) {
                    sb.append(ELEMENT_SEPARATOR);
                }
                sb.append(ToStringHelper.render(oa[i]));
            }
        } else if (Boolean.TYPE.equals(componentType)) {
            boolean[] ba = (boolean[])o;
            for (int i = 0; i < ba.length; ++i) {
                if (i > 0) {
                    sb.append(ELEMENT_SEPARATOR);
                }
                sb.append(ba[i]);
            }
        } else if (Integer.TYPE.equals(componentType)) {
            int[] ia = (int[])o;
            for (int i = 0; i < ia.length; ++i) {
                if (i > 0) {
                    sb.append(ELEMENT_SEPARATOR);
                }
                sb.append(ia[i]);
            }
        } else if (Long.TYPE.equals(componentType)) {
            long[] ia = (long[])o;
            for (int i = 0; i < ia.length; ++i) {
                if (i > 0) {
                    sb.append(ELEMENT_SEPARATOR);
                }
                sb.append(ia[i]);
            }
        } else if (Double.TYPE.equals(componentType)) {
            double[] ia = (double[])o;
            for (int i = 0; i < ia.length; ++i) {
                if (i > 0) {
                    sb.append(ELEMENT_SEPARATOR);
                }
                sb.append(ia[i]);
            }
        } else if (Float.TYPE.equals(componentType)) {
            float[] ia = (float[])o;
            for (int i = 0; i < ia.length; ++i) {
                if (i > 0) {
                    sb.append(ELEMENT_SEPARATOR);
                }
                sb.append(ia[i]);
            }
        } else if (Character.TYPE.equals(componentType)) {
            char[] ia = (char[])o;
            for (int i = 0; i < ia.length; ++i) {
                if (i > 0) {
                    sb.append(ELEMENT_SEPARATOR);
                }
                sb.append(ia[i]);
            }
        } else if (Short.TYPE.equals(componentType)) {
            short[] ia = (short[])o;
            for (int i = 0; i < ia.length; ++i) {
                if (i > 0) {
                    sb.append(ELEMENT_SEPARATOR);
                }
                sb.append(ia[i]);
            }
        } else if (Byte.TYPE.equals(componentType)) {
            byte[] ia = (byte[])o;
            for (int i = 0; i < ia.length; ++i) {
                if (i > 0) {
                    sb.append(ELEMENT_SEPARATOR);
                }
                sb.append(ia[i]);
            }
        }
        sb.append(ARRAY_SUFFIX);
        return sb;
    }
}

