/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.compile;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.ParameterExpression;
import org.hibernate.Query;
import org.hibernate.ejb.HibernateQuery;
import org.hibernate.jpa.criteria.compile.ExplicitParameterInfo;
import org.hibernate.jpa.internal.QueryImpl;
import org.hibernate.jpa.spi.HibernateEntityManagerImplementor;

public class CriteriaQueryTypeQueryAdapter<X>
implements TypedQuery<X>,
HibernateQuery {
    private final HibernateEntityManagerImplementor entityManager;
    private final QueryImpl<X> jpqlQuery;
    private final Map<ParameterExpression<?>, ExplicitParameterInfo<?>> explicitParameterInfoMap;

    public CriteriaQueryTypeQueryAdapter(HibernateEntityManagerImplementor entityManager, QueryImpl<X> jpqlQuery, Map<ParameterExpression<?>, ExplicitParameterInfo<?>> explicitParameterInfoMap) {
        this.entityManager = entityManager;
        this.jpqlQuery = jpqlQuery;
        this.explicitParameterInfoMap = explicitParameterInfoMap;
    }

    @Override
    public Query getHibernateQuery() {
        return this.jpqlQuery.getHibernateQuery();
    }

    public List<X> getResultList() {
        return this.jpqlQuery.getResultList();
    }

    public X getSingleResult() {
        return this.jpqlQuery.getSingleResult();
    }

    public int getMaxResults() {
        return this.jpqlQuery.getMaxResults();
    }

    public TypedQuery<X> setMaxResults(int i) {
        this.jpqlQuery.setMaxResults(i);
        return this;
    }

    public int getFirstResult() {
        return this.jpqlQuery.getFirstResult();
    }

    public TypedQuery<X> setFirstResult(int i) {
        this.jpqlQuery.setFirstResult(i);
        return this;
    }

    public Map<String, Object> getHints() {
        return this.jpqlQuery.getHints();
    }

    public TypedQuery<X> setHint(String name, Object value) {
        this.jpqlQuery.setHint(name, value);
        return this;
    }

    public FlushModeType getFlushMode() {
        return this.jpqlQuery.getFlushMode();
    }

    public TypedQuery<X> setFlushMode(FlushModeType flushModeType) {
        this.jpqlQuery.setFlushMode(flushModeType);
        return this;
    }

    public LockModeType getLockMode() {
        return this.jpqlQuery.getLockMode();
    }

    public TypedQuery<X> setLockMode(LockModeType lockModeType) {
        this.jpqlQuery.setLockMode(lockModeType);
        return this;
    }

    public Set<Parameter<?>> getParameters() {
        this.entityManager.checkOpen(false);
        return new HashSet(this.explicitParameterInfoMap.values());
    }

    public boolean isBound(Parameter<?> param) {
        this.entityManager.checkOpen(false);
        return this.jpqlQuery.isBound(param);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        this.entityManager.checkOpen(false);
        ExplicitParameterInfo parameterInfo = this.resolveParameterInfo(param);
        if (parameterInfo.isNamed()) {
            return (T)this.jpqlQuery.getParameterValue(parameterInfo.getName());
        }
        return (T)this.jpqlQuery.getParameterValue(parameterInfo.getPosition());
    }

    private <T> ExplicitParameterInfo resolveParameterInfo(Parameter<T> param) {
        if (ExplicitParameterInfo.class.isInstance(param)) {
            return (ExplicitParameterInfo)param;
        }
        if (ParameterExpression.class.isInstance(param)) {
            return this.explicitParameterInfoMap.get((ParameterExpression)param);
        }
        for (ExplicitParameterInfo<?> parameterInfo : this.explicitParameterInfoMap.values()) {
            if (param.getName() != null && param.getName().equals(parameterInfo.getName())) {
                return parameterInfo;
            }
            if (param.getPosition() == null || !param.getPosition().equals(parameterInfo.getPosition())) continue;
            return parameterInfo;
        }
        throw new IllegalArgumentException("Unable to locate parameter [" + param + "] in query");
    }

    public <T> TypedQuery<X> setParameter(Parameter<T> param, T t) {
        this.entityManager.checkOpen(false);
        ExplicitParameterInfo parameterInfo = this.resolveParameterInfo(param);
        if (parameterInfo.isNamed()) {
            this.jpqlQuery.setParameter(parameterInfo.getName(), t);
        } else {
            this.jpqlQuery.setParameter(parameterInfo.getPosition(), t);
        }
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar calendar, TemporalType temporalType) {
        this.entityManager.checkOpen(false);
        ExplicitParameterInfo parameterInfo = this.resolveParameterInfo(param);
        if (parameterInfo.isNamed()) {
            this.jpqlQuery.setParameter(parameterInfo.getName(), calendar, temporalType);
        } else {
            this.jpqlQuery.setParameter((int)parameterInfo.getPosition(), calendar, temporalType);
        }
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Date> param, Date date, TemporalType temporalType) {
        this.entityManager.checkOpen(false);
        ExplicitParameterInfo parameterInfo = this.resolveParameterInfo(param);
        if (parameterInfo.isNamed()) {
            this.jpqlQuery.setParameter(parameterInfo.getName(), date, temporalType);
        } else {
            this.jpqlQuery.setParameter((int)parameterInfo.getPosition(), date, temporalType);
        }
        return this;
    }

    public <T> T unwrap(Class<T> cls) {
        return this.jpqlQuery.unwrap(cls);
    }

    public Object getParameterValue(String name) {
        this.entityManager.checkOpen(false);
        this.locateParameterByName(name);
        return this.jpqlQuery.getParameterValue(name);
    }

    private ExplicitParameterInfo locateParameterByName(String name) {
        for (ExplicitParameterInfo<?> parameterInfo : this.explicitParameterInfoMap.values()) {
            if (!parameterInfo.isNamed() || !parameterInfo.getName().equals(name)) continue;
            return parameterInfo;
        }
        throw new IllegalArgumentException("Unable to locate parameter registered with that name [" + name + "]");
    }

    public Parameter<?> getParameter(String name) {
        this.entityManager.checkOpen(false);
        return this.locateParameterByName(name);
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        this.entityManager.checkOpen(false);
        ExplicitParameterInfo parameter = this.locateParameterByName(name);
        if (type.isAssignableFrom(parameter.getParameterType())) {
            return parameter;
        }
        throw new IllegalArgumentException("Named parameter [" + name + "] type is not assignanle to request type [" + type.getName() + "]");
    }

    public TypedQuery<X> setParameter(String name, Object value) {
        this.entityManager.checkOpen(true);
        ExplicitParameterInfo parameterInfo = this.locateParameterByName(name);
        parameterInfo.validateBindValue(value);
        this.jpqlQuery.setParameter(name, value);
        return this;
    }

    public TypedQuery<X> setParameter(String name, Calendar calendar, TemporalType temporalType) {
        this.entityManager.checkOpen(true);
        ExplicitParameterInfo parameterInfo = this.locateParameterByName(name);
        parameterInfo.validateCalendarBind();
        this.jpqlQuery.setParameter(name, calendar, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(String name, Date date, TemporalType temporalType) {
        this.entityManager.checkOpen(true);
        ExplicitParameterInfo parameterInfo = this.locateParameterByName(name);
        parameterInfo.validateDateBind();
        this.jpqlQuery.setParameter(name, date, temporalType);
        return this;
    }

    public int executeUpdate() {
        throw new IllegalStateException("Typed criteria queries do not support executeUpdate");
    }

    public TypedQuery<X> setParameter(int i, Object o) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    public TypedQuery<X> setParameter(int i, Calendar calendar, TemporalType temporalType) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    public TypedQuery<X> setParameter(int i, Date date, TemporalType temporalType) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    public Object getParameterValue(int position) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    public Parameter<?> getParameter(int position) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
    }
}

