/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.spi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.jpa.event.internal.core.HibernateEntityManagerEventListener;
import org.hibernate.jpa.event.internal.core.JpaAutoFlushEventListener;
import org.hibernate.jpa.event.internal.core.JpaDeleteEventListener;
import org.hibernate.jpa.event.internal.core.JpaFlushEntityEventListener;
import org.hibernate.jpa.event.internal.core.JpaFlushEventListener;
import org.hibernate.jpa.event.internal.core.JpaMergeEventListener;
import org.hibernate.jpa.event.internal.core.JpaPersistEventListener;
import org.hibernate.jpa.event.internal.core.JpaPersistOnFlushEventListener;
import org.hibernate.jpa.event.internal.core.JpaPostDeleteEventListener;
import org.hibernate.jpa.event.internal.core.JpaPostInsertEventListener;
import org.hibernate.jpa.event.internal.core.JpaPostLoadEventListener;
import org.hibernate.jpa.event.internal.core.JpaPostUpdateEventListener;
import org.hibernate.jpa.event.internal.core.JpaSaveEventListener;
import org.hibernate.jpa.event.internal.core.JpaSaveOrUpdateEventListener;
import org.hibernate.jpa.event.internal.jpa.CallbackBuilderLegacyImpl;
import org.hibernate.jpa.event.internal.jpa.CallbackRegistryImpl;
import org.hibernate.jpa.event.spi.jpa.CallbackBuilder;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistryConsumer;
import org.hibernate.jpa.event.spi.jpa.ListenerFactory;
import org.hibernate.jpa.event.spi.jpa.ListenerFactoryBuilder;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class JpaIntegrator
implements Integrator {
    private ListenerFactory jpaListenerFactory;
    private CallbackBuilder callbackBuilder;
    private CallbackRegistryImpl callbackRegistry;
    private static final DuplicationStrategy JPA_DUPLICATION_STRATEGY = new JPADuplicationStrategy();
    private static final String CDI_LISTENER_FACTORY_CLASS = "org.hibernate.jpa.event.internal.jpa.BeanManagerListenerFactory";

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        CascadeStyles.registerCascadeStyle((String)"persist", (CascadeStyles.BaseCascadeStyle)new PersistCascadeStyle());
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        eventListenerRegistry.addDuplicationStrategy(JPA_DUPLICATION_STRATEGY);
        eventListenerRegistry.setListeners(EventType.AUTO_FLUSH, (Object[])new AutoFlushEventListener[]{JpaAutoFlushEventListener.INSTANCE});
        eventListenerRegistry.setListeners(EventType.DELETE, (Object[])new DeleteEventListener[]{new JpaDeleteEventListener()});
        eventListenerRegistry.setListeners(EventType.FLUSH_ENTITY, (Object[])new FlushEntityEventListener[]{new JpaFlushEntityEventListener()});
        eventListenerRegistry.setListeners(EventType.FLUSH, (Object[])new FlushEventListener[]{JpaFlushEventListener.INSTANCE});
        eventListenerRegistry.setListeners(EventType.MERGE, (Object[])new MergeEventListener[]{new JpaMergeEventListener()});
        eventListenerRegistry.setListeners(EventType.PERSIST, (Object[])new PersistEventListener[]{new JpaPersistEventListener()});
        eventListenerRegistry.setListeners(EventType.PERSIST_ONFLUSH, (Object[])new PersistEventListener[]{new JpaPersistOnFlushEventListener()});
        eventListenerRegistry.setListeners(EventType.SAVE, (Object[])new SaveOrUpdateEventListener[]{new JpaSaveEventListener()});
        eventListenerRegistry.setListeners(EventType.SAVE_UPDATE, (Object[])new SaveOrUpdateEventListener[]{new JpaSaveOrUpdateEventListener()});
        eventListenerRegistry.prependListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{new JpaPostDeleteEventListener()});
        eventListenerRegistry.prependListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{new JpaPostInsertEventListener()});
        eventListenerRegistry.prependListeners(EventType.POST_LOAD, (Object[])new PostLoadEventListener[]{new JpaPostLoadEventListener()});
        eventListenerRegistry.prependListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{new JpaPostUpdateEventListener()});
        ConfigurationService cfgService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        for (Map.Entry entry : cfgService.getSettings().entrySet()) {
            String propertyName;
            if (!String.class.isInstance(entry.getKey()) || !(propertyName = (String)entry.getKey()).startsWith("hibernate.ejb.event")) continue;
            String eventTypeName = propertyName.substring("hibernate.ejb.event".length() + 1);
            EventType eventType = EventType.resolveEventTypeByName((String)eventTypeName);
            EventListenerGroup eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (String listenerImpl : ((String)entry.getValue()).split(" ,")) {
                eventListenerGroup.appendListener(this.instantiate(listenerImpl, (ServiceRegistryImplementor)serviceRegistry));
            }
        }
        ReflectionManager reflectionManager = ((MetadataImpl)metadata).getMetadataBuildingOptions().getReflectionManager();
        this.callbackRegistry = new CallbackRegistryImpl();
        this.jpaListenerFactory = ListenerFactoryBuilder.buildListenerFactory(sessionFactory.getSessionFactoryOptions());
        this.callbackBuilder = new CallbackBuilderLegacyImpl(this.jpaListenerFactory, reflectionManager);
        for (PersistentClass persistentClass : metadata.getEntityBindings()) {
            if (persistentClass.getClassName() == null) continue;
            this.callbackBuilder.buildCallbacksForEntity(persistentClass.getClassName(), this.callbackRegistry);
        }
        for (EventType eventType : EventType.values()) {
            EventListenerGroup eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (Object listener : eventListenerGroup.listeners()) {
                if (!CallbackRegistryConsumer.class.isInstance(listener)) continue;
                ((CallbackRegistryConsumer)listener).injectCallbackRegistry(this.callbackRegistry);
            }
        }
    }

    private ListenerFactory buildBeanManagerListenerFactory(Object beanManagerRef) {
        try {
            Class<?> beanManagerListenerFactoryClass = this.getClass().getClassLoader().loadClass(CDI_LISTENER_FACTORY_CLASS);
            Method beanManagerListenerFactoryBuilderMethod = beanManagerListenerFactoryClass.getMethod("fromBeanManagerReference", Object.class);
            try {
                return (ListenerFactory)beanManagerListenerFactoryBuilderMethod.invoke(null, beanManagerRef);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Could not locate BeanManagerListenerFactory class to handle CDI extensions", (Throwable)e);
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new HibernateException("Could not access BeanManagerListenerFactory class to handle CDI extensions", e);
        }
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (this.callbackRegistry != null) {
            this.callbackRegistry.release();
        }
        if (this.callbackBuilder != null) {
            this.callbackBuilder.release();
        }
        if (this.jpaListenerFactory != null) {
            this.jpaListenerFactory.release();
        }
    }

    private Object instantiate(String listenerImpl, ServiceRegistryImplementor serviceRegistry) {
        try {
            return ((ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class)).classForName(listenerImpl).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate requested listener [" + listenerImpl + "]", (Throwable)e);
        }
    }

    private static class JPADuplicationStrategy
    implements DuplicationStrategy {
        private JPADuplicationStrategy() {
        }

        public boolean areMatch(Object listener, Object original) {
            return listener.getClass().equals(original.getClass()) && HibernateEntityManagerEventListener.class.isInstance(original);
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    }

    private static class PersistCascadeStyle
    extends CascadeStyles.BaseCascadeStyle {
        private PersistCascadeStyle() {
        }

        public boolean doCascade(CascadingAction action) {
            return action == JpaPersistEventListener.PERSIST_SKIPLAZY || action == CascadingActions.PERSIST_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_PERSIST_SKIPLAZY";
        }
    }
}

