/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.registry.LocalRegistryFactory;
import org.wildfly.clustering.server.registry.RegistryFactoryServiceNameProvider;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupServiceName;

public class LocalRegistryFactoryBuilder<K, V>
extends RegistryFactoryServiceNameProvider
implements Builder<RegistryFactory<K, V>>,
Value<RegistryFactory<K, V>> {
    private final InjectedValue<Group> group = new InjectedValue();

    public LocalRegistryFactoryBuilder(String containerName, String cacheName) {
        super(containerName, cacheName);
    }

    public ServiceBuilder<RegistryFactory<K, V>> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(CacheGroupServiceName.GROUP.getServiceName(this.containerName, this.cacheName), Group.class, this.group).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public RegistryFactory<K, V> getValue() {
        return new LocalRegistryFactory((Group)this.group.getValue());
    }
}

