/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jboss.jca.core.workmanager.ClassDefinition;
import org.jboss.jca.core.workmanager.SecurityActions;

public class ClassDefinitionFactory {
    private ClassDefinitionFactory() {
    }

    public static ClassDefinition createClassDefinition(Serializable s) {
        return ClassDefinitionFactory.createClassDefinition(s, s.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassDefinition createClassDefinition(Serializable s, Class<?> clz) {
        if (s == null || clz == null) {
            return null;
        }
        String name = clz.getName();
        long serialVersionUID = 0L;
        byte[] data = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = null;
        try {
            try {
                Field svuf = ClassDefinitionFactory.getSerialVersionUID(clz);
                if (svuf != null) {
                    serialVersionUID = (Long)svuf.get(s);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            String clzName = name.replace('.', '/') + ".class";
            is = SecurityActions.getClassLoader(s.getClass()).getResourceAsStream(clzName);
            int i = is.read();
            while (i != -1) {
                baos.write(i);
                i = is.read();
            }
            data = baos.toByteArray();
            ClassDefinition classDefinition = new ClassDefinition(name, serialVersionUID, data);
            return classDefinition;
        }
        catch (Throwable t) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }

    private static Field getSerialVersionUID(Class<?> clz) {
        for (Class<?> c = clz; c != null; c = c.getSuperclass()) {
            try {
                Field svuf = SecurityActions.getDeclaredField(clz, "serialVersionUID");
                SecurityActions.setAccessible(svuf);
                return svuf;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        return null;
    }
}

