/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.RemoteSiteConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class RelayConfigurationBuilder
extends AbstractProtocolConfigurationBuilder<RelayConfiguration>
implements RelayConfiguration {
    private final String stackName;
    private final List<ValueDependency<RemoteSiteConfiguration>> sites = new LinkedList<ValueDependency<RemoteSiteConfiguration>>();
    private volatile String siteName = null;

    public RelayConfigurationBuilder(String stackName) {
        super(stackName, "relay.RELAY2");
        this.stackName = stackName;
    }

    @Override
    public ServiceBuilder<RelayConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        for (Dependency dependency : this.sites) {
            dependency.register(builder);
        }
        return builder;
    }

    @Override
    public Builder<RelayConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.sites.clear();
        this.siteName = RelayResourceDefinition.Attribute.SITE.getDefinition().resolveModelAttribute(context, model).asString();
        if (model.hasDefined(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property remoteSiteProperty : model.get(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                String remoteSiteName = remoteSiteProperty.getName();
                this.sites.add((ValueDependency<RemoteSiteConfiguration>)new InjectedValueDependency((ServiceNameProvider)new RemoteSiteConfigurationBuilder(this.stackName, remoteSiteName), RemoteSiteConfiguration.class));
            }
        }
        return super.configure(context, model);
    }

    public RelayConfiguration getValue() {
        return this;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public List<RemoteSiteConfiguration> getRemoteSites() {
        ArrayList<RemoteSiteConfiguration> sites = new ArrayList<RemoteSiteConfiguration>(this.sites.size());
        for (ValueDependency<RemoteSiteConfiguration> site : this.sites) {
            sites.add((RemoteSiteConfiguration)site.getValue());
        }
        return sites;
    }
}

