/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.remoting.transport.jgroups.MarshallerAdapter;
import org.jgroups.Channel;
import org.jgroups.blocks.RpcDispatcher;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ChannelTransport
extends JGroupsTransport {
    private final Channel channel;
    private final ChannelFactory factory;

    public ChannelTransport(Channel channel, ChannelFactory factory) {
        this.channel = channel;
        this.factory = factory;
        this.connectChannel = true;
        this.disconnectChannel = true;
        this.closeChannel = false;
    }

    @Inject
    public void setConfiguration(GlobalConfiguration config) {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.globalJmxStatistics().read(config.globalJmxStatistics()).disable();
        TransportConfiguration transport = config.transport();
        builder.transport().clusterName(transport.clusterName()).distributedSyncTimeout(transport.distributedSyncTimeout()).initialClusterSize(transport.initialClusterSize()).initialClusterTimeout(transport.initialClusterTimeout(), TimeUnit.MILLISECONDS).machineId(transport.machineId()).nodeName(transport.nodeName()).rackId(transport.rackId()).siteId(transport.siteId()).transport(transport.transport()).withProperties((Properties)transport.properties());
        super.setConfiguration(builder.build());
    }

    protected void initRPCDispatcher() {
        this.dispatcher = new CommandAwareRpcDispatcher(this.channel, (JGroupsTransport)this, this.globalHandler, this.getTimeoutExecutor(), this.timeService);
        MarshallerAdapter adapter = new MarshallerAdapter(this.marshaller){

            public Object objectFromBuffer(byte[] buffer, int offset, int length) throws Exception {
                return ChannelTransport.this.isUnknownForkResponse(ByteBuffer.wrap(buffer, offset, length)) ? CacheNotFoundResponse.INSTANCE : super.objectFromBuffer(buffer, offset, length);
            }
        };
        this.dispatcher.setRequestMarshaller((RpcDispatcher.Marshaller)adapter);
        this.dispatcher.setResponseMarshaller((RpcDispatcher.Marshaller)adapter);
        this.dispatcher.start();
    }

    boolean isUnknownForkResponse(ByteBuffer response) {
        return this.factory.isUnknownForkResponse(response);
    }

    protected void initChannel() {
        ((JGroupsTransport)this).channel = this.channel;
        ((JGroupsTransport)this).channel.setDiscardOwnMessages(false);
    }

    static {
        PrivilegedAction<Void> action = () -> {
            System.setProperty("infinispan.stagger.delay", "0");
            return null;
        };
        WildFlySecurityManager.doUnchecked(action);
    }
}

